/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadMat(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\ncalling function with stupid input\n");
  ret=tacReadMat(NULL, NULL, NULL);
  if(ret!=TPCERROR_FAIL) return(1);

  TAC tac; tacInit(&tac);
  ret=tacReadMat(&tac, NULL, NULL);
  if(ret!=TPCERROR_NO_DATA) return(2);

  CSV csv; csvInit(&csv);
  ret=tacReadMat(&tac, &csv, NULL);
  if(ret!=TPCERROR_NO_DATA) return(3);

  if(verbose>1) printf("\nCreating Mat data for testing\n");
  csv.separator='\t';

  ret=csvPutString(&csv, "test2018", 0);
  if(ret==0) ret=csvPutString(&csv, "0-0.5", 0);
  if(ret==0) ret=csvPutString(&csv, "0.5-1", 0);
  if(ret==0) ret=csvPutString(&csv, "1-1.5", 0);
  if(ret==0) ret=csvPutString(&csv, "1.5-2", 0);
  if(ret==0) ret=csvPutString(&csv, "2-3", 0);
  if(ret==0) ret=csvPutString(&csv, "3-4", 0);
  if(ret==0) ret=csvPutString(&csv, "4-5", 0);
  if(ret==0) ret=csvPutString(&csv, "5-10", 0);
  if(ret==0) ret=csvPutString(&csv, "10-15", 0);
  if(ret==0) ret=csvPutString(&csv, "15-20", 0);
  if(ret==0) ret=csvPutString(&csv, "20-25", 0);
  if(ret==0) ret=csvPutString(&csv, "25-30", 0);
  if(ret==0) ret=csvPutString(&csv, "30-35", 0);
  if(ret==0) ret=csvPutString(&csv, "35-40", 0);
  if(ret==0) ret=csvPutString(&csv, "'default'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 0.1+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'dorsal_attention'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 10.2+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'frontoparietal'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 20.3+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'limbic'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 30.4+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'somatomotor'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 40.5+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'ventral_attention'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 50.6+(double)i, 0, 0);
  if(ret==0) ret=csvPutString(&csv, "'visual'", 1);
  for(int i=0; i<14; i++)
    if(ret==0) ret=csvPutDouble(&csv, 60.7+(double)i, 0, 0);
  if(ret) {csvFree(&csv); tacFree(&tac); return(11);}

  if(verbose>1) printf("\ntrying to read the CSV contents\n");
  ret=tacReadMat(&tac, &csv, NULL);
  if(ret!=TPCERROR_OK) {csvFree(&csv); tacFree(&tac); return(12);}
  if(verbose>5) tacWrite(&tac, stdout, TAC_FORMAT_PMOD, 1, NULL);
  if(tac.tacNr!=7 || tac.sampleNr!=14) {csvFree(&csv); tacFree(&tac); return(13);}
  if(!doubleMatch(tac.c[0].y[0], 0.1, 0.001)) {
    csvFree(&csv); tacFree(&tac); return(14);}
  if(!doubleMatch(tac.c[6].y[13], 73.7, 0.001)) {
    csvFree(&csv); tacFree(&tac); return(14);}
  if(!doubleMatch(tac.c[0].size, 0.0, 0.1)) {
    csvFree(&csv); tacFree(&tac); return(15);}
  if(strcmp(tac.c[0].name, "default")!=0) {
    csvFree(&csv); tacFree(&tac); return(16);}
  if(strcmp(tac.c[6].name, "visual")!=0) {
    csvFree(&csv); tacFree(&tac); return(16);}


  csvFree(&csv); tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
