/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadQView(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;

  if(verbose>1) printf("\ncalling function with stupid input\n");
  ret=tacReadQView(NULL, NULL, 0, NULL);
  if(ret!=TPCERROR_FAIL) return(1);

  TAC tac; tacInit(&tac);
  ret=tacReadQView(&tac, NULL, 0, NULL);
  if(ret!=TPCERROR_NO_DATA) return(2);

  CSV csv; csvInit(&csv);
  ret=tacReadQView(&tac, &csv, 9, NULL);
  if(ret!=TPCERROR_NO_DATA) return(3);

  if(verbose>1) printf("\nCreating CSV data for testing; no region name\n");
  ret=csvPutString(&csv, "directory", 0);
  if(ret==0) ret=csvPutString(&csv, "file name", 0);
  if(ret==0) ret=csvPutString(&csv, "num", 0);
  if(ret==0) ret=csvPutString(&csv, "slice", 0);
  if(ret==0) ret=csvPutString(&csv, "mean", 0);
  if(ret==0) ret=csvPutString(&csv, "sd", 0);
  if(ret==0) ret=csvPutString(&csv, "cov", 0);
  if(ret==0) ret=csvPutString(&csv, "max", 0);
  if(ret==0) ret=csvPutString(&csv, "min", 0);
  if(ret==0) ret=csvPutString(&csv, "pixel", 0);
  if(ret==0) ret=csvPutString(&csv, "total", 0);
  if(ret==0) ret=csvPutString(&csv, "group", 0);
  if(ret) {csvFree(&csv); tacFree(&tac); return(10);}
  ret=csvPutString(&csv, "S:\\research\\mypath", 1);
  if(ret==0) ret=csvPutString(&csv, "qviewio.v", 0);
  if(ret==0) ret=csvPutString(&csv, "1(01)", 0);
  if(ret==0) ret=csvPutString(&csv, "12", 0);
  if(ret==0) ret=csvPutString(&csv, "29.751", 0);
  if(ret==0) ret=csvPutString(&csv, "4.798", 0);
  if(ret==0) ret=csvPutString(&csv, "16.128", 0);
  if(ret==0) ret=csvPutString(&csv, "39.764", 0);
  if(ret==0) ret=csvPutString(&csv, "19.482", 0);
  if(ret==0) ret=csvPutString(&csv, "43", 0);
  if(ret==0) ret=csvPutString(&csv, "1279.303", 0);
  if(ret==0) ret=csvPutString(&csv, "", 0);
  if(ret) {csvFree(&csv); tacFree(&tac); return(11);}

  if(verbose>1) printf("\ntrying to read the CSV contents\n");
  ret=tacReadQView(&tac, &csv, 0, NULL);
  if(ret!=TPCERROR_OK) {csvFree(&csv); tacFree(&tac); return(12);}
  if(verbose>5) tacWrite(&tac, stdout, TAC_FORMAT_DFT, 1, NULL);
  if(tac.tacNr!=1 || tac.sampleNr!=1) {csvFree(&csv); tacFree(&tac); return(13);}
  if(!doubleMatch(tac.c[0].y[0], 29.751, 0.001)) {
    csvFree(&csv); tacFree(&tac); return(14);}
  if(!doubleMatch(tac.c[0].size, 43.0, 0.1)) {
    csvFree(&csv); tacFree(&tac); return(15);}
  if(strcmp(tac.c[0].name, "roi1__pl12")!=0) {
    csvFree(&csv); tacFree(&tac); return(16);}


  if(verbose>1) printf("\nCreating CSV data for testing; group\n");
  ret=csvCellReplace(&csv, 1, 11, "liver");
  if(ret==TPCERROR_OK) ret=csvCellReplace(&csv, 1, 2, " (01)");
  if(ret==TPCERROR_OK) ret=csvCellReplace(&csv, 1, 3, "");
  if(ret!=TPCERROR_OK) {csvFree(&csv); tacFree(&tac); return(21);}

  if(verbose>1) printf("\ntrying to read the CSV contents\n");
  ret=tacReadQView(&tac, &csv, 0, NULL);
  if(ret!=TPCERROR_OK) {csvFree(&csv); tacFree(&tac); return(22);}
  if(verbose>5) tacWrite(&tac, stdout, TAC_FORMAT_DFT, 1, NULL);
  if(tac.tacNr!=1 || tac.sampleNr!=1) {csvFree(&csv); tacFree(&tac); return(23);}
  if(!doubleMatch(tac.c[0].y[0], 29.751, 0.001)) {
    csvFree(&csv); tacFree(&tac); return(24);}
  if(!doubleMatch(tac.c[0].size, 43.0, 0.1)) {
    csvFree(&csv); tacFree(&tac); return(25);}
  if(strcmp(tac.c[0].name, "liver")!=0) {
    csvFree(&csv); tacFree(&tac); return(26);}

  csvFree(&csv); tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
