/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacWriteSimple(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  FILE *fp;
  TAC tac; tacInit(&tac);
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 1;
  
  if(verbose>1) printf("writing test data without extra header\n");
  char fname1[]="simple.dat";
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&tac); return 2;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSimple(&tac, fp, 0, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 3;}

  if(verbose>1) printf("writing test data with extra header\n");
  char fname2[]="simple2.dat";
  fp=fopen(fname2, "w");
  if(fp==NULL) {tacFree(&tac); return 12;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteSimple(&tac, fp, 1, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 13;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacReadSimple(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  if(verbose>0) printf("tests included in testing of tacRead()\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
