/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
#include "tpcisotope.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  TAC tac;
  tacInit(&tac);
  tacInit((TAC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_taccInit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  TACC tacc;
  taccInit(&tacc);
  taccInit((TACC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");

  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacFreeExceptHeader(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  tacFreeExceptHeader((TAC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  TAC tac;  tacInit(&tac); tacFreeExceptHeader(&tac);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  tacFree((TAC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  TAC tac;  tacInit(&tac); tacFree(&tac);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_taccFree(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  taccFree((TACC*)NULL);
  if(verbose>1) printf("did not segfault, that is good.\n");
  TACC tacc;  taccInit(&tacc); taccFree(&tacc);
  if(verbose>1) printf("did not segfault, that is good.\n");
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacAllocate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=tacAllocate((TAC*)NULL, 2, 2);
  if(ret==TPCERROR_OK) return 1;

  TAC tac;
  tacInit(&tac);

  if(verbose>1) printf("allocating memory for zero data\n");
  ret=tacAllocate(&tac, 0, 0);
  if(ret!=TPCERROR_OK) return 2;
  if(tac._tacNr!=0 || tac._sampleNr!=0) return 2;
  tacFree(&tac);

  if(verbose>1) printf("allocating memory for some data\n");
  ret=tacAllocate(&tac, 3, 2);
  if(ret!=TPCERROR_OK) return 3;
  if(tac._tacNr!=2 || tac._sampleNr!=3) return 3;
  if(tac.tacNr!=0 || tac.sampleNr!=0) return 3;
  if(verbose>1) printf("put also some content in there\n");
  for(int i=0; i<tac._sampleNr; i++) {
    tac.x[i]=(double)(i+1);
    for(int j=0; j<tac._tacNr; j++)
      tac.c[j].y[i]=(double)(i+1+2*j);
  }
  tac.tacNr=tac._tacNr; tac.sampleNr=tac._sampleNr;
  if(verbose>1) printf("check that contents are as they should be\n");
  ret=0;
  for(int i=0; i<tac._sampleNr; i++) {
    if(fabs(tac.x[i]-(double)(i+1)) > 1.0E-08) ret++;
    for(int j=0; j<tac._tacNr; j++)
      if(fabs(tac.c[j].y[i]-(double)(i+1+2*j)) > 1.0E-08) ret++;
  }
  
  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(ret);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacAllocateMore(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=tacAllocateMore((TAC*)NULL, 2);
  if(ret==TPCERROR_OK) return 1;

  TAC tac;
  tacInit(&tac);

  if(verbose>1) printf("reallocating memory for zero data\n");
  ret=tacAllocateMore(&tac, 2);
  if(ret==TPCERROR_OK) return 2;
  if(tac._tacNr!=0 || tac._sampleNr!=0) return 2;
  tacFree(&tac);

  if(verbose>1) printf("\nallocating memory for some data\n");
  ret=tacAllocate(&tac, 3, 3);
  if(ret!=TPCERROR_OK) return 3;
  if(tac._tacNr!=3 || tac._sampleNr!=3) return 3;
  if(tac.tacNr!=0 || tac.sampleNr!=0) return 3;
  if(verbose>1) printf("put also some content in there\n");
  for(int i=0; i<3; i++) {
    tac.x[i]=(double)(i+1);
    for(int j=0; j<2; j++)
      tac.c[j].y[i]=(double)(i+1+2*j);
  }
  tac.tacNr=2; tac.sampleNr=3;

  if(verbose>1) printf("\nreallocating memory while there is no neeed to do that\n");
  ret=tacAllocateMore(&tac, 1);
  if(ret!=TPCERROR_OK) return 4;
  if(verbose>1) printf("check that contents are as they should be\n");
  ret=0;
  if(tac.sampleNr!=3) ret++;
  if(tac._sampleNr!=3) ret++;
  if(tac.tacNr!=2) ret++;
  if(tac._tacNr!=3) ret++;
  for(int i=0; i<tac.sampleNr; i++) {
    if(fabs(tac.x[i]-(double)(i+1)) > 1.0E-08) ret++;
    for(int j=0; j<tac.tacNr; j++)
      if(fabs(tac.c[j].y[i]-(double)(i+1+2*j)) > 1.0E-08) ret++;
  }
  if(ret>0) {
    if(verbose>1) printf("previous data was changed in reallocation.\n");
    tacFree(&tac); return(4);
  }

  if(verbose>1) printf("\nactually reallocating memory\n");
  ret=tacAllocateMore(&tac, 8);
  if(ret!=TPCERROR_OK) return 5;
  if(verbose>1) printf("check that contents are as they should be\n");
  ret=0;
  if(tac.sampleNr!=3) ret++;
  if(tac._sampleNr!=3) ret++;
  if(tac.tacNr!=2) ret++;
  if(tac._tacNr!=10) ret++;
  if(verbose>2) {
    printf("  _sampleNr := %d\n", tac._sampleNr);
    printf("  sampleNr := %d\n", tac.sampleNr);
    printf("  _tacNr := %d\n", tac._tacNr);
    printf("  tacNr := %d\n", tac.tacNr);
  }
  for(int i=0; i<tac.sampleNr; i++) {
    if(fabs(tac.x[i]-(double)(i+1)) > 1.0E-08) ret++;
    for(int j=0; j<tac.tacNr; j++)
      if(fabs(tac.c[j].y[i]-(double)(i+1+2*j)) > 1.0E-08) ret++;
  }
  if(ret>0) {
    if(verbose>1) printf("previous data was changed in reallocation.\n");
    tacFree(&tac); return(5);
  }

  if(verbose>1) printf("\ncheck that all (re)allocated memory can be used\n");
  tac.tacNr=tac._tacNr;
  for(int i=0; i<tac.sampleNr; i++) {
    tac.x[i]=(double)(i+1);
    for(int j=0; j<tac.tacNr; j++)
      tac.c[j].y[i]=(double)(i+1+2*j);
  }
  if(verbose>1) printf("check that contents are as they should be\n");
  ret=0;
  for(int i=0; i<tac.sampleNr; i++) {
    if(fabs(tac.x[i]-(double)(i+1)) > 1.0E-08) ret++;
    for(int j=0; j<tac.tacNr; j++)
      if(fabs(tac.c[j].y[i]-(double)(i+1+2*j)) > 1.0E-08) ret++;
  }
  if(ret>0) {
    if(verbose>1) printf("cannot use reallocated memory.\n");
    tacFree(&tac); return(6);
  }

  tacFree(&tac);
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCopyTacc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) 
    printf("We can be sure we will notice if this function does not work.\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCopyTaccdata(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) 
    printf("We can be sure we will notice if this function does not work.\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCopyTacchdr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) 
    printf("We can be sure we will notice if this function does not work.\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCopyHdr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) 
    printf("Will be tested with applications using this function.\n");
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacIsSize(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  if(verbose>1) printf("testing with NULL pointer.\n");
  ret=tacIsSize((TAC*)NULL);
  if(verbose>2) printf("no crash, that is good.\n");
  if(ret!=0) return 1;

  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying with zero data\n");
  ret=tacIsSize(&tac); if(ret!=0) return 2;

  if(verbose>1) printf("making test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 3;}
  
  if(verbose>1) printf("no volumes\n");
  for(int i=0; i<tac.tacNr; i++) tac.c[i].size=nan("");
  ret=tacIsSize(&tac); if(ret!=0) {tacFree(&tac); return 11;}
  
  if(verbose>1) printf("with volumes\n");
  for(int i=0; i<tac.tacNr; i++) tac.c[i].size=1.0;
  ret=tacIsSize(&tac); if(ret==0) {tacFree(&tac); return 12;}
  
  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacDuplicate(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  
  if(verbose>1) printf("\n testing with NULL pointer.\n");
  ret=tacDuplicate((TAC*)NULL, (TAC*)NULL);
  if(verbose>2) printf("no crash, that is good.\n");
  if(ret==0) return 1;

  TAC tac1, tac2;
  tacInit(&tac1); tacInit(&tac2);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacDuplicate(&tac1, &tac2);
  if(ret==0) return 2;

  if(verbose>1) printf("\n making test data\n");
  ret=create_tac(&tac1); if(ret!=TPCERROR_OK) {tacFree(&tac1); return 10;}

  if(verbose>1) printf("\n duplicating test data.\n");
  ret=tacDuplicate(&tac1, &tac2);
  if(ret!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  if(verbose>3) {
    printf("\n source TAC:\n"); 
    tacWrite(&tac1, stdout, TAC_FORMAT_PMOD, 1, NULL);
    printf("\n duplicate TAC:\n"); 
    tacWrite(&tac2, stdout, TAC_FORMAT_PMOD, 1, NULL);
  }
  if(tacCompareUnit(&tac1, &tac2, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 12;}
  if(tacCompareNames(&tac1, &tac2, -1, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 13;}
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-08, 1.0E-08, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 14;}
  if(tacCompareTimes(&tac1, &tac2, 1.0E-08, 1.0E-08, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 15;}

  
  tacFree(&tac1); tacFree(&tac2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacExtract(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  
  if(verbose>1) printf("\n testing with NULL pointer.\n");
  ret=tacExtract((TAC*)NULL, (TAC*)NULL, 0);
  if(verbose>2) printf("no crash, that is good.\n");
  if(ret==TPCERROR_OK) return 1;

  TAC tac1, tac2; tacInit(&tac1); tacInit(&tac2);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacExtract(&tac1, &tac2, -1);
  if(ret==TPCERROR_OK) return 2;
  ret=tacExtract(&tac1, &tac2, 0);
  if(ret==TPCERROR_OK) return 3;

  if(verbose>1) printf("\n making test data\n");
  ret=create_tac(&tac1); if(ret!=TPCERROR_OK) {tacFree(&tac1); return 10;}
  tacSetWeights(&tac1, WEIGHTING_ON_F, tac1.sampleNr, NULL);

  if(verbose>1) printf("\n try to extract from bad index.\n");
  ret=tacExtract(&tac1, &tac2, -1);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 11;}
  ret=tacExtract(&tac1, &tac2, tac1.tacNr);
  if(ret==TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 12;}

  if(verbose>1) printf("\n extract from index 0.\n");
  ret=tacExtract(&tac1, &tac2, 0);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 21;}
  if(verbose>3) {
    printf("\n source TAC:\n"); 
    tacWrite(&tac1, stdout, TAC_FORMAT_PMOD, 1, NULL);
    printf("\n result TAC:\n"); 
    tacWrite(&tac2, stdout, TAC_FORMAT_PMOD, 1, NULL);
  }
  if(tacCompareTimes(&tac1, &tac2, 1.0E-12, 1.0E-08, NULL) ||
     tacCompareUnit(&tac1, &tac2, NULL) ||
     tacCompareWeights(&tac1, &tac2, 1.0E-12, 1.0E-08, NULL) ||
     !doubleMatch(tac1.c[0].y[0], tac2.c[0].y[0], 1.0E-12) ||
     !doubleMatch(tac1.c[0].y[tac1.sampleNr-1], tac2.c[0].y[tac1.sampleNr-1], 1.0E-12) ) {
    tacFree(&tac1); tacFree(&tac2); return 22;}

  if(verbose>1) printf("\n extract from last index.\n");
  ret=tacExtract(&tac1, &tac2, tac1.tacNr-1);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 31;}
  if(verbose>3) {
    printf("\n source TAC:\n"); 
    tacWrite(&tac1, stdout, TAC_FORMAT_PMOD, 1, NULL);
    printf("\n result TAC:\n"); 
    tacWrite(&tac2, stdout, TAC_FORMAT_PMOD, 1, NULL);
  }
  if(tacCompareTimes(&tac1, &tac2, 1.0E-12, 1.0E-08, NULL) ||
     tacCompareUnit(&tac1, &tac2, NULL) ||
     tacCompareWeights(&tac1, &tac2, 1.0E-12, 1.0E-08, NULL) ||
     !doubleMatch(tac1.c[tac1.tacNr-1].y[0], tac2.c[0].y[0], 1.0E-12) ||
     !doubleMatch(tac1.c[tac1.tacNr-1].y[tac1.sampleNr-1], tac2.c[0].y[tac1.sampleNr-1], 1.0E-12) ) {
    tacFree(&tac1); tacFree(&tac2); return 32;}

  tacFree(&tac1); tacFree(&tac2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacAllocateMoreSamples(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  
  if(verbose>1) printf("\n testing with NULL pointer.\n");
  ret=tacAllocateMoreSamples((TAC*)NULL, 10);
  if(verbose>2) printf("no crash, that is good.\n");
  if(ret==0) return 1;

  TAC tac1, tac2;
  tacInit(&tac1); tacInit(&tac2);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacAllocateMoreSamples(&tac1, 10);
  if(ret==0) return 2;

  if(verbose>1) printf("\n making test data\n");
  ret=create_tac(&tac1); if(ret==0) ret=create_tac(&tac2);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac1); return 10;}

  if(verbose>1) printf("\n adding more space \n");
  ret=tacAllocateMoreSamples(&tac2, 10);
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac1); return 11;}
  
  if(verbose>1) printf("\n _sampleNr should be increased \n");
  if(tac2._sampleNr!=tac1.sampleNr+10) {
    tacFree(&tac1); tacFree(&tac1); return 12;
  }
  
  if(verbose>1) 
    printf("\n otherwise the data should be the same as before \n");
  if(tacCompareUnit(&tac1, &tac2, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 13;}
  if(tacCompareNames(&tac1, &tac2, -1, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 14;}
  if(tacCompareConc(&tac1, &tac2, -1, 1.0E-08, 1.0E-08, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 15;}
  if(tacCompareTimes(&tac1, &tac2, 1.0E-08, 1.0E-08, status)!=0) {
    tacFree(&tac1); tacFree(&tac2); return 16;}

  tacFree(&tac1); tacFree(&tac2);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
/** Create test TAC data */
int create_tac(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 5, 3); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=3; tac->sampleNr=5;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_KBQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "roi%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(100*(ri+1));
  /* Set data contents */
  for(fi=0; fi<tac->sampleNr; fi++) {
    tac->x1[fi]=(double)fi; tac->x2[fi]=(double)(fi+1);
    tac->x[fi]=0.5*(tac->x1[fi]+tac->x2[fi]);
    for(ri=0; ri<tac->tacNr; ri++) {
      tac->c[ri].y[fi]=(double)((ri+1)*(fi+ri)-2);
      //printf("%d %d %g\n", fi, ri, tac->c[ri].y[fi]);
    }
  }
  /* Set header fields */
  ret=iftPut(&tac->h, "studynr", "test0001", (char)1, NULL);
  ret=iftPut(&tac->h, "scantime", "2013-11-18 14:02:54", (char)1, NULL);
  ret=iftPut(&tac->h, "injection_time", "2013-11-18 14:02:53", (char)1, NULL);
  ret=iftPut(&tac->h, "isotope", "C-11", (char)1, NULL);
  
  return TPCERROR_OK;
}
/******************************************************************************/

/******************************************************************************/
/** Create another test TAC data */
int create_tac2(
  TAC *tac
) {
  int ret, fi, ri;
  
  /* Allocate memory */
  ret=tacAllocate(tac, 15, 1); if(ret!=TPCERROR_OK) return ret;
  tac->tacNr=1; tac->sampleNr=15;
  /* Set TAC information */
  tac->weighting=WEIGHTING_OFF;
  tac->cunit=UNIT_BQ_PER_ML;
  tac->tunit=UNIT_MIN;
  tac->isframe=1;
  /* Set region names */
  for(ri=0; ri<tac->tacNr; ri++) sprintf(tac->c[ri].name, "roi%d", 1+ri);
  /* Set volumes */
  for(ri=0; ri<tac->tacNr; ri++) tac->c[ri].size=(double)(1000*(ri+1));
  /* Set data contents */
  for(fi=0; fi<tac->sampleNr; fi++) {
    tac->x1[fi]=(double)fi; tac->x2[fi]=(double)(fi+1);
    tac->x[fi]=0.5*(tac->x1[fi]+tac->x2[fi]);
    for(ri=0; ri<tac->tacNr; ri++) {
      tac->c[ri].y[fi]=(double)((ri+1)*(fi+ri)-2);
      //printf("%d %d %g\n", fi, ri, tac->c[ri].y[fi]);
    }
  }
  /* Set header fields */
  ret=iftPut(&tac->h, "studynr", "test0002", (char)1, NULL);
  ret=iftPut(&tac->h, "scantime", "2014-11-13 15:43:13", (char)1, NULL);
  ret=iftPut(&tac->h, "injection_time", "2014-11-13 15:43:12", (char)1, NULL);
  ret=iftPut(&tac->h, "isotope", "F-18", (char)1, NULL);
  
  return TPCERROR_OK;
}
/******************************************************************************/

/******************************************************************************/
