/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacCompareUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=tacCompareUnit(NULL, NULL, status);
  if(n==0) {return 1;}  
  
  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);

  if(verbose>1) printf("should work with empty TAC structs\n");
  n=tacCompareUnit(&tac1, &tac2, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 2;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_tac(&tac1); if(ret==0) ret=create_tac(&tac2); 
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 3;}
  
  if(verbose>1) printf("similar data should match\n");
  n=tacCompareUnit(&tac1, &tac2, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  
  if(verbose>1) printf("different x unit\n");
  tac1.tunit=UNIT_SEC; tac2.tunit=UNIT_MIN;
  n=tacCompareUnit(&tac1, &tac2, status);
  if(n!=2) {tacFree(&tac1); tacFree(&tac2); return 12;}
  
  if(verbose>1) printf("different x and y unit\n");
  tac1.cunit=UNIT_KBQ_PER_ML; tac2.cunit=UNIT_BQ_PER_ML;
  n=tacCompareUnit(&tac1, &tac2, status);
  if(n!=3) {tacFree(&tac1); tacFree(&tac2); return 13;}
  
  if(verbose>1) printf("different y unit\n");
  tac1.tunit=UNIT_MSEC; tac2.tunit=UNIT_MSEC;
  n=tacCompareUnit(&tac1, &tac2, status);
  if(n!=1) {tacFree(&tac1); tacFree(&tac2); return 15;}


  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac1); tacFree(&tac2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCompareNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=tacCompareNames(NULL, NULL, -1, status);
  if(n==0) {return 1;}
  
  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);

  if(verbose>1) printf("should not crash with empty TAC structs\n");
  n=tacCompareNames(&tac1, &tac2, -1, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 2;}
  n=tacCompareNames(&tac1, &tac2, 1, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_tac(&tac1); if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 4;}
  ret=create_tac(&tac2); if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=tacCompareNames(&tac1, &tac2, -1, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  n=tacCompareNames(&tac1, &tac2, 0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 12;}
  n=tacCompareNames(&tac1, &tac2, 1, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 13;}
  /* but too large index should have no match */
  n=tacCompareNames(&tac1, &tac2, 9999, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 15;}

  if(verbose>1) printf("different names should not match\n");
  strcpy(tac2.c[1].name, "newname");
  n=tacCompareNames(&tac1, &tac2, -1, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 21;}
  n=tacCompareNames(&tac1, &tac2, 0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 22;}
  n=tacCompareNames(&tac1, &tac2, 1, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 23;}
  n=tacCompareNames(&tac1, &tac2, 2, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 24;}
  
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac1); tacFree(&tac2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCompareConc(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=tacCompareConc(NULL, NULL, -1, 0.0, 0.0, status);
  if(n==0) {return 1;}
  
  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);

  if(verbose>1) printf("should not crash with empty TAC structs\n");
  n=tacCompareConc(&tac1, &tac2, -1, 0.0, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 2;}
  n=tacCompareConc(&tac1, &tac2, 1, 0.0, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 3;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_tac(&tac1); if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 4;}
  ret=create_tac(&tac2); if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 5;}
  
  if(verbose>1) printf("similar data should match\n");
  n=tacCompareConc(&tac1, &tac2, -1, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  n=tacCompareConc(&tac1, &tac2, 0, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 12;}
  n=tacCompareConc(&tac1, &tac2, 1, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 13;}
  /* but too large index should have no match */
  n=tacCompareConc(&tac1, &tac2, 9999, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 15;}

  if(verbose>1) printf("different y values should not match\n");
  tac1.c[1].y[1]=123.4;
  tac2.c[1].y[1]=123.5;
  n=tacCompareConc(&tac1, &tac2, -1, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 21;}
  n=tacCompareConc(&tac1, &tac2, 0, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 22;}
  n=tacCompareConc(&tac1, &tac2, 1, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 23;}
  n=tacCompareConc(&tac1, &tac2, 2, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 24;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=tacCompareConc(&tac1, &tac2, -1, 0.15, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 21;}
  n=tacCompareConc(&tac1, &tac2, 1, 0.15, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 22;}
  if(verbose>1) printf("... or relative limit\n");
  n=tacCompareConc(&tac1, &tac2, -1, 0.0, 0.01, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 23;}
  n=tacCompareConc(&tac1, &tac2, 1, 0.0, 0.01, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 24;}
  
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac1); tacFree(&tac2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCompareTimes(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=tacCompareTimes(NULL, NULL, 0.0, 0.0, status);
  if(n==0) {return 1;}
  
  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);

  if(verbose>1) printf("should not crash with empty TAC structs\n");
  n=tacCompareTimes(&tac1, &tac2, 0.0, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 2;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_tac(&tac1); if(ret==0) ret=create_tac(&tac2); 
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 4;}

  if(verbose>1) printf("similar data should match\n");
  tac1.isframe=0; tac2.isframe=0;
  n=tacCompareTimes(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  tac1.isframe=1; tac2.isframe=1;
  n=tacCompareTimes(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 12;}
  if(verbose>1) printf("... except if time type is different\n");
  tac1.isframe=0; tac2.isframe=1;
  n=tacCompareTimes(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 13;}
  
  if(verbose>1) printf("different x values should not match\n");
  tac1.x1[tac1.sampleNr-1]=123.4;
  tac1.x2[tac1.sampleNr-1]=tac1.x1[tac1.sampleNr-1]+120;
  tac1.x[tac1.sampleNr-1]=0.5*(tac1.x1[tac1.sampleNr-1]+tac1.x2[tac1.sampleNr-1]);
  tac2.x1[tac2.sampleNr-1]=123.5;
  tac2.x2[tac2.sampleNr-1]=tac2.x1[tac2.sampleNr-1]+120;
  tac2.x[tac2.sampleNr-1]=0.5*(tac2.x1[tac2.sampleNr-1]+tac2.x2[tac2.sampleNr-1]);
  tac1.isframe=0; tac2.isframe=0;
  n=tacCompareTimes(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 21;}
  tac1.isframe=1; tac2.isframe=1;
  n=tacCompareTimes(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 22;}
  if(verbose>1) printf("... except if difference is within the limit\n");
  n=tacCompareTimes(&tac1, &tac2, 0.15, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 23;}
  tac1.isframe=0; tac2.isframe=0;
  n=tacCompareTimes(&tac1, &tac2, 0.15, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 24;}
  if(verbose>1) printf("or within the relative limit\n");
  tac1.isframe=1; tac2.isframe=1;
  n=tacCompareTimes(&tac1, &tac2, 0.0, 0.01, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 25;}
  tac1.isframe=0; tac2.isframe=0;
  n=tacCompareTimes(&tac1, &tac2, 0.0, 0.01, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 26;}
  
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac1); tacFree(&tac2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacCompareWeights(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  int n, ret;
  
  if(verbose>1) printf("should not crash with NULL input\n");
  n=tacCompareWeights(NULL, NULL, 0.0, 0.0, status);
  if(n==0) {return 1;}
  
  TAC tac1; tacInit(&tac1);
  TAC tac2; tacInit(&tac2);

  if(verbose>1) printf("should not crash with empty TAC structs\n");
  n=tacCompareWeights(&tac1, &tac2, 0.0, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 2;}
  
  if(verbose>1) printf("create test data\n");
  ret=create_tac(&tac1); if(ret==0) ret=create_tac(&tac2); 
  if(ret!=TPCERROR_OK) {tacFree(&tac1); tacFree(&tac2); return 4;}

  if(verbose>1) printf("similar data should match\n");
  tac1.weighting=tac2.weighting=WEIGHTING_OFF;
  n=tacCompareWeights(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 11;}
  
  for(int i=0; i<tac1.sampleNr; i++)
    tac1.w[i]=tac2.w[i]=0.1*(double)(i+2);
  tac1.weighting=tac2.weighting=WEIGHTING_ON_GENERAL;
  n=tacCompareWeights(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n!=0) {tacFree(&tac1); tacFree(&tac2); return 12;}

  if(verbose>1) printf("different weights should not match\n");
  tac1.w[tac1.sampleNr-1]=9.99;
  n=tacCompareWeights(&tac1, &tac2, 1.0E-20, 0.0, status);
  if(n==0) {tacFree(&tac1); tacFree(&tac2); return 21;}
  
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  tacFree(&tac1); tacFree(&tac2);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
