/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "tpcift.h"
#include "tpcisotope.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderStudynr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char str[MAX_STUDYNR_LEN+1];

  if(verbose>1) printf("trying to get studynr from empty header\n");
  ret=tacGetHeaderStudynr(&tac.h, str, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get studynr from filled header\n");
  ret=tacGetHeaderStudynr(&tac.h, str, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) printf("  --> studynr := '%s'\n", str);
  if(strcmp(str, "test0001")!=0) {tacFree(&tac); return 12;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderStudynr(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char s1[MAX_STUDYNR_LEN+1], s2[MAX_STUDYNR_LEN+1];

  if(verbose>1) printf("set studynr in empty header\n");
  strcpy(s1, "abc123");
  ret=tacSetHeaderStudynr(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  ret=tacGetHeaderStudynr(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 13;}

  if(verbose>1) printf("delete studynr\n");
  strcpy(s1, "");
  ret=tacSetHeaderStudynr(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  ret=tacGetHeaderStudynr(&tac.h, s2, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 22;}

  tacFree(&tac);

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 31;
  
  if(verbose>1) printf("replace existing studynr\n");
  strcpy(s1, "huhhuh");
  ret=tacSetHeaderStudynr(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 32;}
  ret=tacGetHeaderStudynr(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 33;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 34;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying to get unit from empty TAC\n");
  ret=tacGetHeaderUnit(&tac, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get unit from empty header\n");
  ret=tacGetHeaderUnit(&tac, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 2;}
  if(tac.cunit!=UNIT_UNKNOWN) {tacFree(&tac); return 3;}

  if(verbose>1) printf("trying to get unit from filled header\n");
  ret=iftPut(&tac.h, "unit", "Bq/cc", (char)1, NULL);
  ret=tacGetHeaderUnit(&tac, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(tac.cunit!=UNIT_BQ_PER_ML) {tacFree(&tac); return 12;}

  if(verbose>1) printf("header should no more contain unit\n");
  ret=tacGetHeaderUnit(&tac, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 13;}
  if(tac.cunit!=UNIT_UNKNOWN) {tacFree(&tac); return 14;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderUnit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying to set unit into empty TAC\n");
  ret=tacSetHeaderUnit(&tac.h, UNIT_BQ_PER_ML);
  if(ret!=TPCERROR_OK) return 1;
  ret=tacGetHeaderUnit(&tac, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 2;}
  if(tac.cunit!=UNIT_BQ_PER_ML) {tacFree(&tac); return 3;}

  ret=tacSetHeaderUnit(&tac.h, UNIT_KCPM);
  if(ret!=TPCERROR_OK) return 11;
  ret=tacSetHeaderUnit(&tac.h, UNIT_UNKNOWN);
  if(ret!=TPCERROR_OK) return 12;
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderTimeunit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying to get time unit from empty TAC\n");
  ret=tacGetHeaderTimeunit(&tac, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get time unit from empty header\n");
  ret=tacGetHeaderTimeunit(&tac, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 2;}
  if(tac.tunit!=UNIT_UNKNOWN) {tacFree(&tac); return 3;}

  if(verbose>1) printf("trying to get unit from filled header\n");
  ret=iftPut(&tac.h, "timeunit", "hours", (char)1, NULL);
  ret=tacGetHeaderTimeunit(&tac, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(tac.tunit!=UNIT_HOUR) {tacFree(&tac); return 12;}

  if(verbose>1) printf("header should no more contain unit\n");
  ret=tacGetHeaderTimeunit(&tac, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 13;}
  if(tac.tunit!=UNIT_UNKNOWN) {tacFree(&tac); return 14;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderTimeunit(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying to set time unit into empty TAC\n");
  ret=tacSetHeaderTimeunit(&tac.h, UNIT_SEC);
  if(ret!=TPCERROR_OK) return 1;
  ret=tacGetHeaderTimeunit(&tac, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 2;}
  if(tac.tunit!=UNIT_SEC) {tacFree(&tac); return 3;}

  ret=tacSetHeaderTimeunit(&tac.h, UNIT_UM);
  if(ret!=TPCERROR_OK) return 11;
  ret=tacSetHeaderTimeunit(&tac.h, UNIT_UNKNOWN);
  if(ret!=TPCERROR_OK) return 12;
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderIsotope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char str[MAX_ISOTOPE_LEN+1];

  if(verbose>1) printf("trying to get isotope from empty header\n");
  ret=tacGetHeaderIsotope(&tac.h, str, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get isotope from filled header\n");
  ret=tacGetHeaderIsotope(&tac.h, str, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) printf("  --> isotope := '%s'\n", str);
  if(strcmp(str, "C-11")!=0) {tacFree(&tac); return 12;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderIsotope(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char s1[MAX_ISOTOPE_LEN+1], s2[MAX_ISOTOPE_LEN+1];

  if(verbose>1) printf("set isotope in empty header\n");
  strcpy(s1, "C-11");
  ret=tacSetHeaderIsotope(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  ret=tacGetHeaderIsotope(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 13;}

  if(verbose>1) printf("delete isotope\n");
  strcpy(s1, "");
  ret=tacSetHeaderIsotope(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  ret=tacGetHeaderIsotope(&tac.h, s2, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 22;}

  tacFree(&tac);

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 31;
  
  if(verbose>1) printf("replace existing isotope\n");
  strcpy(s1, "F-18");
  ret=tacSetHeaderIsotope(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 32;}
  ret=tacGetHeaderIsotope(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 33;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 34;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderScanstarttime(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char str[20];

  if(verbose>1) printf("trying to get scan_start_time from empty header\n");
  ret=tacGetHeaderScanstarttime(&tac.h, str, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get scan_start_time from filled header\n");
  ret=tacGetHeaderScanstarttime(&tac.h, str, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) printf("  --> scan_start_time := '%s'\n", str);
  if(strcmp(str, "2013-11-18 14:02:54")!=0) {tacFree(&tac); return 12;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderScanstarttime(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char s1[20], s2[20];

  if(verbose>1) printf("set scan_start_time in empty header\n");
  strcpy(s1, "2013-11-18 14:02:54");
  ret=tacSetHeaderScanstarttime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  ret=tacGetHeaderScanstarttime(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 13;}

  if(verbose>1) printf("delete scan_start_time\n");
  strcpy(s1, "");
  ret=tacSetHeaderScanstarttime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  ret=tacGetHeaderScanstarttime(&tac.h, s2, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 22;}

  tacFree(&tac);

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 31;
  
  if(verbose>1) printf("replace existing scan_start_time\n");
  strcpy(s1, "2014-08-23 08:02:54");
  ret=tacSetHeaderScanstarttime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 32;}
  ret=tacGetHeaderScanstarttime(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 33;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 34;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderInjectiontime(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char str[20];

  if(verbose>1) printf("trying to get injection_time from empty header\n");
  ret=tacGetHeaderInjectiontime(&tac.h, str, NULL);
  if(ret==TPCERROR_OK) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  
  if(verbose>1) printf("trying to get injection_time from filled header\n");
  ret=tacGetHeaderInjectiontime(&tac.h, str, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  if(verbose>2) printf("  --> injection_time := '%s'\n", str);
  if(strcmp(str, "2013-11-18 14:02:53")!=0) {tacFree(&tac); return 12;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderInjectiontime(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);
  char s1[20], s2[20];

  if(verbose>1) printf("set injection_time in empty header\n");
  strcpy(s1, "2013-11-18 14:02:54");
  ret=tacSetHeaderInjectiontime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  ret=tacGetHeaderInjectiontime(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 12;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 13;}

  if(verbose>1) printf("delete injection_time\n");
  strcpy(s1, "");
  ret=tacSetHeaderInjectiontime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  ret=tacGetHeaderInjectiontime(&tac.h, s2, NULL);
  if(ret==TPCERROR_OK) {tacFree(&tac); return 22;}

  tacFree(&tac);

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 31;
  
  if(verbose>1) printf("replace existing injection_time\n");
  strcpy(s1, "2014-08-23 08:02:53");
  ret=tacSetHeaderInjectiontime(&tac.h, s1);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 32;}
  ret=tacGetHeaderInjectiontime(&tac.h, s2, NULL);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 33;}
  if(strcmp(s1, s2)!=0) {tacFree(&tac); return 34;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacGetHeaderDecayCorrection(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  decaycorrection dc;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying to get decay correction status from empty header\n");
  dc=tacGetHeaderDecayCorrection(&tac.h);
  if(dc!=DECAY_UNKNOWN) return 1;
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 2;
  ret=tacSetHeaderDecayCorrection(&tac.h, DECAY_CORRECTED);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  dc=tacGetHeaderDecayCorrection(&tac.h);
  if(dc!=DECAY_CORRECTED) {tacFree(&tac); return 12;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacSetHeaderDecayCorrection(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  decaycorrection dc;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("set decay correction status in empty header\n");
  ret=tacSetHeaderDecayCorrection(&tac.h, DECAY_CORRECTED);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  dc=tacGetHeaderDecayCorrection(&tac.h);
  if(dc!=DECAY_CORRECTED) {tacFree(&tac); return 12;}

  if(verbose>1) printf("delete decay correction status\n");
  tacSetHeaderDecayCorrection(&tac.h, DECAY_UNKNOWN);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 21;}
  dc=tacGetHeaderDecayCorrection(&tac.h);
  if(dc!=DECAY_UNKNOWN) {tacFree(&tac); return 22;}

  if(verbose>1) printf("set decay correction status\n");
  ret=tacSetHeaderDecayCorrection(&tac.h, DECAY_NOTCORRECTED);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 31;}
  dc=tacGetHeaderDecayCorrection(&tac.h);
  if(dc!=DECAY_NOTCORRECTED) {tacFree(&tac); return 32;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
