/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacIndividualNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;
  TAC tac; tacInit(&tac);

  ret=tacIndividualNames(&tac);
  if(ret) return(1);

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}

  ret=tacIndividualNames(&tac);
  if(!ret) {tacFree(&tac); return(12);}

  for(int i=0; i<tac.tacNr; i++) strcpy(tac.c[i].name, "");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(13);}

  for(int i=0; i<tac.tacNr; i++) strcpy(tac.c[i].name, "tac");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(14);}

  strcpy(tac.c[0].name, "TAC");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(15);}

  for(int i=0; i<tac.tacNr; i++) strcpy(tac.c[i].name, "___");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(16);}

  strcpy(tac.c[0].name, "__");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(17);}

  tac.tacNr=1; strcpy(tac.c[0].name, "___");
  ret=tacIndividualNames(&tac);
  if(ret) {tacFree(&tac); return(21);}

  tac.tacNr=1; strcpy(tac.c[0].name, "TAC");
  ret=tacIndividualNames(&tac);
  if(!ret) {tacFree(&tac); return(22);}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacEnsureNames(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  if(verbose>1) printf("testing with NULL pointer.\n");
  tacEnsureNames((TAC*)NULL);
  if(verbose>2) printf("no crash, that is good.\n");

  int ret;
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("trying with zero data\n");
  ret=tacAllocate(&tac, 0, 0); if(ret!=TPCERROR_OK) return 2;
  tacEnsureNames(&tac);
  if(verbose>2) printf("no crash, that is good.\n");
  tacFree(&tac);

  if(verbose>1) printf("trying with some data\n");
  ret=tacAllocate(&tac, 3, 2); if(ret!=TPCERROR_OK) return 3;
  for(int i=0; i<tac._sampleNr; i++) {
    tac.x[i]=(double)(i+1);
    for(int j=0; j<tac._tacNr; j++)
      tac.c[j].y[i]=(double)(i+1+2*j);
  }
  tac.tacNr=tac._tacNr; tac.sampleNr=tac._sampleNr;
  tacEnsureNames(&tac);
  if(strcmp(tac.c[0].name, "1")!=0) {tacFree(&tac); return 4;}
  if(strcmp(tac.c[1].name, "2")!=0) {tacFree(&tac); return 5;}
  if(verbose>2) printf("ok\n");

  strcpy(tac.c[0].name, ".");
  tacEnsureNames(&tac);
  if(strcmp(tac.c[0].name, "1")!=0) {tacFree(&tac); return 6;}
  if(strcmp(tac.c[1].name, "2")!=0) {tacFree(&tac); return 7;}

  tacFree(&tac);

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
