/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacXNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret, n;
  TAC tac; tacInit(&tac);

  n=tacXNaNs(&tac);
  if(n!=0) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  n=tacXNaNs(&tac); if(n!=0) {tacFree(&tac); return 12;}
  
  tac.x[1]=tac.x1[1]=tac.x2[1]=nan("");
  tac.isframe=1;
  n=tacXNaNs(&tac); if(n!=2) {tacFree(&tac); return 21;}
  tac.isframe=0;
  n=tacXNaNs(&tac); if(n!=1) {tacFree(&tac); return 22;}
  
  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacYNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret, n, m;
  TAC tac; tacInit(&tac);

  n=tacYNaNs(&tac, -1);  if(n!=0) {tacFree(&tac); return 1;}
  n=tacYNaNs(&tac, 0);   if(n!=0) {tacFree(&tac); return 2;}
  n=tacYNaNs(&tac, 100); if(n!=0) {tacFree(&tac); return 3;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  n=tacYNaNs(&tac, -1); if(n!=0) {tacFree(&tac); return 12;}
  n=tacYNaNs(&tac,  0); if(n!=0) {tacFree(&tac); return 13;}
  n=tacYNaNs(&tac, 10); if(n!=0) {tacFree(&tac); return 14;}
  
  m=tac.tacNr;
  for(int i=0; i<m; i++) tac.c[i].y[1]=nan("");
  n=tacYNaNs(&tac, -1); if(n!=m) {tacFree(&tac); return 21;}
  n=tacYNaNs(&tac,  0); if(n!=1) {tacFree(&tac); return 22;}
  n=tacYNaNs(&tac, 10); if(n!=0) {tacFree(&tac); return 23;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret, n, m;
  TAC tac; tacInit(&tac);

  n=tacNaNs(&tac); if(n!=0) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  n=tacNaNs(&tac); if(n!=0) {tacFree(&tac); return 12;}
  
  m=tac.tacNr;
  for(int i=0; i<m; i++) tac.c[i].y[1]=nan("");
  tac.x[1]=tac.x1[1]=tac.x2[1]=nan("");
  tac.isframe=1;
  n=tacNaNs(&tac); if(n!=2+m) {tacFree(&tac); return 21;}
  tac.isframe=0;
  n=tacNaNs(&tac); if(n!=1+m) {tacFree(&tac); return 22;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacNotNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret, n;
  TAC tac; tacInit(&tac);

  n=tacNotNaNs(&tac, -1); if(n!=0) {tacFree(&tac); return 1;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  n=tacNotNaNs(&tac, -1); if(n!=tac.sampleNr) {tacFree(&tac); return 12;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr) {tacFree(&tac); return 13;}

  tac.c[1].y[1]=nan("");
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 21;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr) {tacFree(&tac); return 22;}
  tac.x[1]=nan("");
  tac.isframe=1;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 23;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr) {tacFree(&tac); return 24;}
  tac.isframe=0;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 25;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr-1) {tacFree(&tac); return 26;}
  n=tacNotNaNs(&tac, -1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 27;}

  tac.x[1]=1.0; tac.x1[1]=tac.x2[1]=nan("");
  tac.isframe=1;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 31;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr-1) {tacFree(&tac); return 32;}
  tac.isframe=0;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 33;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr) {tacFree(&tac); return 34;}

  tac.c[1].y[1]=1.0;
  tac.isframe=1;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 41;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr-1) {tacFree(&tac); return 42;}
  tac.isframe=0;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr) {tacFree(&tac); return 43;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr) {tacFree(&tac); return 44;}

  for(int i=0; i<tac.tacNr; i++) tac.c[i].y[1]=nan("");
  tac.x[1]=tac.x1[1]=tac.x2[1]=1.0;
  n=tacNotNaNs(&tac, 1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 51;}
  n=tacNotNaNs(&tac, 0); if(n!=tac.sampleNr-1) {tacFree(&tac); return 52;}
  n=tacNotNaNs(&tac, -1); if(n!=tac.sampleNr-1) {tacFree(&tac); return 53;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacFixNaNs(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret;

  if(verbose>1) printf("\n Trying with NULL data \n\n");
  ret=tacFixNaNs(NULL);
  if(ret==0) return 1;

  TAC tac; tacInit(&tac);

  if(verbose>1) printf("\n Trying with empty data \n\n");
  ret=tacFixNaNs(&tac);
  if(ret==0) return 2;

  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}

  if(verbose>1) printf("\n Trying with data without NaNs \n\n");
  ret=tacFixNaNs(&tac);
  if(ret!=0) {tacFree(&tac); return 11;}

  if(verbose>1) printf("\n NaN in sample times should fail \n\n");
  tac.x1[0]=nan(""); tac.isframe=1;
  ret=tacFixNaNs(&tac);
  if(ret==0) {tacFree(&tac); return 12;}
  tac.x1[0]=0.0; tac.x[0]=nan(""); tac.isframe=0;
  ret=tacFixNaNs(&tac);
  if(ret==0) {tacFree(&tac); return 13;}

  if(verbose>1) printf("\n First sample can be fixed. \n\n");
  tacFree(&tac);
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 10;}
  tac.c[1].y[0]=nan("");
  ret=tacFixNaNs(&tac);
  if(ret!=0) {tacFree(&tac); return 21;}

  if(verbose>1) printf("\n Last sample cannot be fixed. \n\n");
  tac.c[0].y[tac.sampleNr-1]=nan("");
  ret=tacFixNaNs(&tac);
  if(ret==0) {tacFree(&tac); return 22;}

  if(verbose>1) printf("\n Fixing gives reasonable results. \n\n");

  TAC tac2; tacInit(&tac2);
  ret=create_tac(&tac2); 
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return 10;}
  tac2.isframe=0;

  tacFree(&tac); ret=create_tac(&tac); 
  if(ret!=TPCERROR_OK) {tacFree(&tac); tacFree(&tac2); return 10;}
  tac.isframe=0;
  if(verbose>2) {
    printf("\noriginal data:\n");
    tacWrite(&tac, stdout, TAC_FORMAT_PMOD, 0, NULL);
  }

  tac.c[0].y[1]=nan("");
  tac.c[1].y[2]=nan("");
  tac.c[2].y[3]=nan("");
  if(verbose>2) {
    printf("\ndata to be fixed:\n");
    tacWrite(&tac, stdout, TAC_FORMAT_PMOD, 0, NULL);
  }

  ret=tacFixNaNs(&tac);
  if(ret!=0) {tacFree(&tac); tacFree(&tac2); return 31;}
  if(verbose>2) {
    printf("\ndata after fixing:\n");
    tacWrite(&tac, stdout, TAC_FORMAT_PMOD, 0, NULL);
  }
  ret=tacCompareConc(&tac2, &tac, -1, 1.0E-06, 1.0E-06, NULL);
  if(ret!=0) {tacFree(&tac); tacFree(&tac2); return 32;}
  ret=tacCompareTimes(&tac2, &tac, 1.0E-06, 1.0E-06, NULL);
  if(ret!=0) {tacFree(&tac); tacFree(&tac2); return 33;}

  tacFree(&tac); tacFree(&tac2);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacNthSample(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }
  
  int ret, n;
  TAC tac; tacInit(&tac);

  n=tacNthSample(&tac, 0, -1); if(n>=0) {tacFree(&tac); return 1;}
  n=tacNthSample(&tac, 1, -1); if(n>=0) {tacFree(&tac); return 2;}
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 11;}
  n=tacNthSample(&tac, -1, -1); if(n>=0) {tacFree(&tac); return 12;}
  n=tacNthSample(&tac, 0, -1); if(n>=0) {tacFree(&tac); return 13;}
  n=tacNthSample(&tac, 1, -1); if(n!=0) {tacFree(&tac); return 14;}
  n=tacNthSample(&tac, tac.sampleNr, -1); 
  if(n!=tac.sampleNr-1) {tacFree(&tac); return 15;}

  tac.c[1].y[0]=nan("");
  n=tacNthSample(&tac, 1, -1); if(n!=1) {tacFree(&tac); return 21;}
  n=tacNthSample(&tac, 1, 0); if(n!=0) {tacFree(&tac); return 22;}
  n=tacNthSample(&tac, 1, 1); if(n!=1) {tacFree(&tac); return 23;}
  n=tacNthSample(&tac, tac.sampleNr, -1); if(n>=0) {tacFree(&tac); return 24;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, -1), -1); 
  if(n!=tac.sampleNr-1) {tacFree(&tac); return 25;}

  tac.c[0].y[tac.sampleNr-1]=nan("");
  n=tacNthSample(&tac, 1, -1); if(n!=1) {tacFree(&tac); return 31;}
  n=tacNthSample(&tac, 1, 0); if(n!=0) {tacFree(&tac); return 32;}
  n=tacNthSample(&tac, 1, 1); if(n!=1) {tacFree(&tac); return 33;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, -1), -1); 
  if(n!=tac.sampleNr-2) {tacFree(&tac); return 34;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, 0), 0); 
  if(n!=tac.sampleNr-2) {tacFree(&tac); return 35;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, 1), 1); 
  if(n!=tac.sampleNr-1) {tacFree(&tac); return 36;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, 2), 2); 
  if(n!=tac.sampleNr-1) {tacFree(&tac); return 37;}
  
  tacFree(&tac);
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) {tacFree(&tac); return 40;}

  tac.x[0]=nan(""); 
  tac.x2[tac.sampleNr-1]=nan(""); 
  tac.isframe=1;
  n=tacNthSample(&tac, 1, -1); if(n!=0) {tacFree(&tac); return 41;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, -1), -1); 
  if(n!=tac.sampleNr-2) {tacFree(&tac); return 42;}
  tac.isframe=0;
  n=tacNthSample(&tac, 1, -1); if(n!=1) {tacFree(&tac); return 43;}
  n=tacNthSample(&tac, tacNotNaNs(&tac, -1), -1); 
  if(n!=tac.sampleNr-1) {tacFree(&tac); return 44;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
