/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctac.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacWriteXML(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  FILE *fp;
  TAC tac; tacInit(&tac);
  
  if(verbose>1) printf("creating test data\n");
  ret=create_tac(&tac); if(ret!=TPCERROR_OK) return 1;
  
  if(verbose>1) printf("writing test data\n");
  char fname1[]="simple.xml";
  fp=fopen(fname1, "w");
  if(fp==NULL) {tacFree(&tac); return 2;}
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  ret=tacWriteXML(&tac, fp, status); fclose(fp);
  if(ret!=TPCERROR_OK) {tacFree(&tac); return 3;}

  tacFree(&tac);
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
