/*****************************************************************************/
#include "tpcclibConfig.h"
/*****************************************************************************/
#include "unistd.h"
/*****************************************************************************/
#include "tpcextensions.h"
#include "test_tpctacmod.h"
/*****************************************************************************/

/*****************************************************************************/
int test_tacAllocateWithPAR(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  TAC tac; tacInit(&tac);
  PAR par; parInit(&par);

  if(verbose>1) printf("\n testing with NULL data.\n");
  ret=tacAllocateWithPAR(NULL, NULL, 0, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacAllocateWithPAR(&tac, &par, 6, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n real testing in other test functions using this.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_parAllocateWithTAC(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  PAR par; parInit(&par);
  TAC tac; tacInit(&tac);

  if(verbose>1) printf("\n testing with NULL data.\n");
  ret=parAllocateWithTAC(NULL, NULL, 0, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=parAllocateWithTAC(&par, &tac, 1, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n real testing in other test functions using this.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
int test_tacToPAR(
  TPCSTATUS *status
) {
  int verbose=0; if(status!=NULL) verbose=status->verbose;
  statusSet(status, __func__, __FILE__, __LINE__, 0);
  if(verbose>0) {
    printf("\n=====================================\n");
    printf("\n%s\n", __func__);
    printf("\n=====================================\n");
  }

  int ret;
  TAC tac; tacInit(&tac);
  PAR par; parInit(&par);

  if(verbose>1) printf("\n testing with NULL data.\n");
  ret=tacToPAR(NULL, NULL, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(1);

  if(verbose>1) printf("\n testing with empty data.\n");
  ret=tacToPAR(&tac, &par, NULL);
  tacFree(&tac); parFree(&par);
  if(ret==TPCERROR_OK) return(2);

  if(verbose>1) printf("\n real testing in other test functions using this.\n");

  statusSet(status, __func__, __FILE__, __LINE__, 0);
  return(0);
}
/*****************************************************************************/

/*****************************************************************************/
