#!/bin/bash
#: Title      : test_parget
#: Date       : 2018-06-01
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../parget$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n make test data \n"

if [ ! -f test1.csv ] || [ ! -f test1.res ] || [ ! -f test1.fit ] || [ ! -f test1.ift ]; then
  printf "parameters,K1,K1/k2,k3,k4\n" > test1.csv
  printf "put_dx,1.0,2.0,3.0,4.0\n"   >> test1.csv
  printf "cau_dx,2.0,3.0,4.0,5.0\n"   >> test1.csv
  printf "put_sin,3.0,4.0,5.0,6.0\n"  >> test1.csv
  printf "cau_sin,4.0,5.0,6.0,7.0\n"  >> test1.csv
  printf "cereb,1.0,1.0,0.0,0.0\n"    >> test1.csv

  parformat -f=RES test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=FIT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  parformat -f=IFT test1.csv
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test2.csv ]; then
  printf "parameters,R1,SD,k2,BPnd,95%%CL1,95%%CL2\n" > test2.csv
  printf "put,1.0,0.05,0.1,1.0,0.9,1.1\n"    >> test2.csv
  printf "cau,1.0,0.04,0.2,2.0,1.9,2.1\n"    >> test2.csv
  printf "cer,1.0,0.03,0.3,0.0,-0.1,0.1\n"   >> test2.csv
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Select TAC and parameter with names. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.csv K1/k2 cereb)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Select TAC and parameter with names. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.res K1/k2 cereb)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.2 \n"
printf " Test case 1: Select TAC and parameter with names. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.ift K1/k2 cereb)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.1 \n"
printf " Test case: More than one TAC matches given string. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM test1.csv K1/k2 put &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot identify a single parameter value."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.2 \n"
printf " Test case: but it does not matter that K1 is part of the name of two parameters. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.csv K1 cereb)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Select TAC and parameter with numbers. \n"
printf " Test case 2: CSV format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.csv 3 4)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="6" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case 1: Select TAC and parameter with numbers. \n"
printf " Test case 2: RES format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.res 3 4)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="6" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case 1: Select TAC and parameter with numbers. \n"
printf " Test case 2: FIT format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.fit 3 4)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="6" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.3 \n"
printf " Test case 1: Select TAC and parameter with numbers. \n"
printf " Test case 2: IFT format. \n"
printf " Expected result: correct parameter value printed. \n\n"

OUTPUT="$($PROGRAM test1.ift 3 4)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="6" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 3.0.0 \n"
printf " Test case: Print existing SD. \n"
printf " Expected result: correct SD value printed. \n\n"

OUTPUT="$($PROGRAM -sd test2.csv R1 cer)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="0.03" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.1 \n"
printf " Test case: Try to print nonexisting SD. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -sd test2.csv k2 cer &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "requested a missing value."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Print existing CL1. \n"
printf " Expected result: correct CL1 value printed. \n\n"

OUTPUT="$($PROGRAM -cl1 test2.csv BPnd cau)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1.9" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.1.1 \n"
printf " Test case: Try to print nonexisting CL1. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -cl1 test2.csv k2 cau &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "requested a missing value."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.1.2 \n"
printf " Test case: Print existing but negative CL1. \n"
printf " Expected result: correct CL1 value printed. \n\n"

OUTPUT="$($PROGRAM -cl1 test2.csv BPnd cer)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="-0.1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 \n"
printf " Test case: Print existing CL2. \n"
printf " Expected result: correct CL2 value printed. \n\n"

OUTPUT="$($PROGRAM -cl2 test2.csv BPnd put)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! ${OUTPUT}=="1.1" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

