#!/bin/bash
#: Title      : test_fvar4tac
#: Date       : 2018-11-15
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../fvar4tac$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f fvar4tac.tac ] || [ ! -f unitless.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f correct_meansd1.tac ] || [ ! -f correct_sd1.tac ] || [ ! -f correct_sd1b.tac ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_sd2a.tac ] || [ ! -f correct_sd2b.tac ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f two.tac ] ; then
  taccalc fvar4tac.tac x 0.5 two.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  taccalc fvar4tac.tac x 1.5 temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd two.tac temp.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg two.svg two.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f multi.tac ] ; then
  tacadd --silent multi.tac fvar4tac.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd --silent multi.tac multi.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f sec.tac ] ; then
  cp -f fvar4tac.tac sec.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacunit -xconv=sec sec.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Option -SD. \n"
printf " Test case 2: One TAC in file. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sd fvar4tac.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -sd -common=yes fvar4tac.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Option -SD. \n"
printf " Test case 2: One TAC in file. \n"
printf " Expected result: Correct CV for noise simulation saved. \n\n"

rm -f cv.dat
taccalc correct_sd1.tac div fvar4tac.tac test.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -cv fvar4tac.tac 1 C-11 cv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 test.tac cv.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Option -minsd. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sd -minsd=2 fvar4tac.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1b.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case 1: Options -SD and -common=yes. \n"
printf " Test case 2: Two TACs in file. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sd -common=yes two.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd2a.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case 1: Options -SD and -common=no. \n"
printf " Test case 2: Two TACs in file. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sd -common=no two.tac 4 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd2b.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Lots of TACs in the file. \n"
printf " Expected result 1: Mean of noisy TACs is close to original. \n"
printf " Expected result 2: SD of noisy TACs is close to requested SD. \n\n"

rm -f output.tac mean.tac sd.dat

$PROGRAM multi.tac 1 C-11 output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmean -sd=sd.dat output.tac mean.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=1 -rel=25 fvar4tac.tac mean.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.2 -rel=15 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.4.0 \n"
printf " Test case: Option -R. \n"
printf " Expected result 1: Requested number of files saved with correct names. \n"
printf " Expected result 2: Mean of noisy TACs is close to original. \n"
printf " Expected result 3: SD of noisy TACs is close to requested SD. \n\n"

rm -f output_0001.tac output_0500.tac

$PROGRAM -R=500 fvar4tac.tac 1 C-11 output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

if [ ! -f output_0001.tac ] ; then printf "Failed!\n" ; exit 1 ; fi
if [ ! -f output_0500.tac ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

avgttac -sd=sd.dat mean.tac output_????.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=1 -rel=15 fvar4tac.tac mean.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.2 -rel=15 correct_meansd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Time units in seconds. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sd sec.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Time units in minutes. \n"
printf " Test case 2: Option -sec unnecessarily. \n"
printf " Expected result: Correct SD for noise simulation saved. \n\n"

rm -f sd.dat

$PROGRAM -sec -sd fvar4tac.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Time units are missing. \n"
printf " Expected result: Assumed to be in minutes. \n\n"

rm -f sd.dat

$PROGRAM -sd unitless.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Option -sec when time units are missing. \n"
printf " Expected result: Not any more the same results. \n\n"

rm -f sd.dat

$PROGRAM -sd -sec unitless.tac 1 C-11 sd.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.002 correct_sd1.tac sd.dat
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   Error handling \n"
printf "===================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption two.tac 1 C-11 output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM two.tac 1 C-11 output.tac extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.2 \n"
printf " Test case: Missing argument(s). \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM two.tac 1 C-11  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt Error
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 \n"
printf " Test case: Invalid isotope. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM two.tac 1 Fu-17 output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid isotope 'Fu-17'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 \n"
printf " Test case: Invalid proportionality constant. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM two.tac -1 C-11 output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid noise level (Pc) '-1'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM two.tac C-11 output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid noise level (Pc) 'C-11'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.1 \n"
printf " Test case: Noise level set to zero. \n"
printf " Expected result 1: Warning. \n"
printf " Expected result 2: Results saved without noise. \n\n"

rm -f output.tac stdout.txt

$PROGRAM two.tac 0 C-11 output.tac &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval stdout.txt Warning "noise level is zero."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.001 two.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.3.0 \n"
printf " Test case: Non-existing input file. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.tac
$PROGRAM nonexisting.tac 1 C-11 output.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexisting.tac)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

