#!/bin/bash
#: Title      : test_simcirc
#: Date       : 2016-06-06
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simcirc$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Default settings. \n"
printf " Expected result: ASCII matrix is created, usable for creating image. \n\n"

rm -f test.dat test.bin ascii.v
$PROGRAM 64 8 test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

asc2flat test.dat test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ascii.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ascii.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Option -format=float. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin float.v
$PROGRAM -format=float 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin float.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb float.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Inverted values with option -inv. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin invert.v
$PROGRAM -inv -format=float 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin invert.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb invert.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 2.0.0 \n"
printf " Test case: Ring with option -diam2. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring.v
$PROGRAM -format=float -diam2=13 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Diameters can be in reverse order. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring2.v
$PROGRAM -format=float -diam2=8 64 13 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring2.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring2.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Ring with inverted values. \n"
printf " Expected result: Flat binary file is created, usable for creating image. \n\n"

rm -f test.bin ring3.v
$PROGRAM -inv -format=float -diam2=13 64 8 test.bin
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

flat2img -scanner=HRRT test.bin ring3.v 1 1 64 64
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb ring3.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
