#!/bin/bash
#: Title      : test_simframe
#: Date       : 2019-09-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../simframe$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"
if [ ! -f correct_6_1_1.dft ] || [ ! -f correct_6_2_1.dft ] || [ ! -f correct_6_2_2.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f correct_6_3_2.dft ] || [ ! -f correct_6_3_3.dft ] || [ ! -f correct_6_3_4.dft ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f frames.dat ] || [ ! -f frames2.dat ] || [ ! -f frames3.dat ] || [ ! -f frames4.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f frames7.dat ] || [ ! -f frames7b.dat ] || [ ! -f frames7c.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f frames3.sif ] || [ ! -f frames4.sif ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f frames_with_gap.dat ] || [ ! -f frames_with_gap.sif ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f frames_with_overlap.dat ] || [ ! -f frames_with_overlap.sif ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi
if [ ! -f t01.dat ] || [ ! -f t11.dat ] || [ ! -f t21.dat ]; then
  printf "Failed: required test data do not exist.\n"
  exit 1
fi



printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n1.1.0 Unknown option\n\n"

rm -f stdout.txt
$PROGRAM -stupidoption t01.dat frames.dat output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.2.0 Extra argument\n\n"

rm -f stdout.txt
$PROGRAM t01.dat frames.dat output.dat C-11 extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.3.0 Option -mid\n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt midFrame 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -mid t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt midFrame 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.3.1 Option -min and -sec\n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt knownTimeunit
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -min t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt knownTimeunit min
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -sec t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt knownTimeunit sec
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.3.2 Option -i and -ii\n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt mode 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -i t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt mode 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -ii t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt mode 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -i t01.dat frames.dat output.dat C-11 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error  "decay option cannot be used with integrals."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 -ii t01.dat frames.dat output.dat C-11 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error  "decay option cannot be used with integrals."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n2.1.1 Input filename not given\n\n"

rm -f stdout.txt
$PROGRAM -d  frames.dat output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing file name; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n2.1.2 Nonexisting input file\n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.dat frames.dat output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file (nonexistingfile.dat)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n2.1.3 Wrong file format\n\n"

rm -f stdout.txt
$PROGRAM $PROGRAM frames.dat output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n3.1.1 Frame filename not given\n\n"

rm -f stdout.txt
$PROGRAM -d t01.dat  output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing file name; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n3.1.2 Nonexisting frame file\n\n"

rm -f stdout.txt
$PROGRAM t01.dat nonexistingfile.dat output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open nonexistingfile.dat"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n3.1.3 Wrong file format\n\n"

rm -f stdout.txt
$PROGRAM t01.dat $PROGRAM output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n4.1.1 Output filename not given\n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing file name; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n5.1.1 Isotope code: not given\n\n"

rm -f stdout.txt
$PROGRAM -d t01.dat frames.dat output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope"
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n5.1.2 Isotope code: invalid\n\n"

rm -f stdout.txt
$PROGRAM t01.dat frames.dat output.dat C-12 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid isotope argument 'C-12'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n5.2.1 Isotope code: C-11 or c-11 or 11C \n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat C-11 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat c-11 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat 11C &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "C-11"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n5.3.1 Isotope code: F-18 or f-18 or 18F \n\n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat F-18 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat f-18 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

rm -f stdout.txt
$PROGRAM -d2 t01.dat frames.dat output.dat 18F &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "F-18"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n5.4.1 Isotope code: O-15 \n\n"

rm -f stdout.txt
$PROGRAM -d t01.dat frames.dat output.dat O-15 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "isotope" "O-15"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n6.1.1 Frame file with frame durations\n\n"

rm -f output.dat
$PROGRAM t01.dat frames.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_1_1.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n6.2.1 Another frame file with frame durations\n\n"

rm -f output.dat
$PROGRAM t11.dat frames2.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_2_1.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n6.2.2 Another frame file with frame durations - with isotope\n\n"

rm -f output.dat
$PROGRAM t11.dat frames2.dat output.dat C-11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# Note that decay correction of frames does not give exactly same result
tacmatch -abs=1 -x=y -y=y correct_6_2_2.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n6.3.1 Frame file with frame start times and durations\n\n"

rm -f output.dat
$PROGRAM t01.dat frames3.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_1_1.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n in SIF \n\n"

rm -f output.tac
$PROGRAM t01.dat frames3.sif output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_1_1.dft output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n in TAC file that was made above \n\n"

rm -f output2.tac
$PROGRAM t01.dat output.tac output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_1_1.dft output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n but proper TAC file without frame start and end times must not work \n\n"

rm -f output2.tac stdout.txt
tacformat -mid -f=PMOD output.tac temp.bld
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM t01.dat temp.bld output2.tac &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "no frame start and end times in temp.bld"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"



printf "\n===================================================================\n"

printf "\n6.3.2 Frame file with frame start times and durations - not starting from zero\n\n"

rm -f output.dat
$PROGRAM t01.dat frames4.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_2.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n in SIF \n\n"

rm -f output.dat
$PROGRAM t01.dat frames4.sif output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_2.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n6.3.3 Frame file has small gap \n\n"

rm -f output.dat
$PROGRAM t01.dat frames_with_gap.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_3.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n in SIF \n\n"

rm -f output.dat
$PROGRAM t01.dat frames_with_gap.sif output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_3.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n6.3.4 Frame file has small overlap \n\n"

rm -f output.dat
$PROGRAM t01.dat frames_with_overlap.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_4.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n in SIF \n\n"

rm -f output.dat
$PROGRAM t01.dat frames_with_overlap.sif output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -x=y -y=y correct_6_3_4.dft output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n7.1.1 Bolus type TAC \n\n"

rm -f output.tac
interpol -c=0,90,0.05 t21.dat test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -x=0.5,3,10,30,67.5 test.dat correct_7_1_1.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM -mid test.dat frames7.dat output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.02 -x=y -y=y correct_7_1_1.dft output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n7.1.2 Bolus type TAC - with isotope \n\n"

rm -f output.dat output2.dat test2.dat

interpol -c=0,90,0.05 t21.dat test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacdecay -decay=off -i=C-11 test.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM --silent test2.dat frames7.dat test2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacdecay -decay=on -i=C-11 test2.tac correct_7_1_2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM test.dat frames7.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.dat frames7.dat output2.dat C-11
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch -abs=0.02 -x=y -y=y correct_7_1_2.dft output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n7.2.1 Short extrapolation is ok without isotope, but not with isotope \n\n"

rm -f test.dat output.dat output2.dat stdout.txt
interpol -c=0,92,0.05 t21.dat test.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.dat frames7b.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM test.dat frames7b.dat output.dat C-11 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "required extrapolation is too risky."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"

printf "\n7.2.2 Too much extrapolation is never ok \n\n"

rm -f output2.dat stdout.txt

$PROGRAM test.dat frames7c.dat output2.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "required extrapolation is too risky."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

$PROGRAM test.dat frames7c.dat output2.dat C-11 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "required extrapolation is too risky."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

