#!/bin/bash
#: Title      : test_tacdelna
#: Date       : 2018-06-06
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacdelna$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f data1.dat ]; then
  printf "0 0 1 -1\n1 0 2 -2 \n" > data1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data2.dat ]; then
  printf "0 0 1 -1\n1 0 2 . \n" > data2.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data3.dat ]; then
  printf "0 . 1 .\n1 0 . . \n" > data3.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f data4.dat ] || [ ! -f correct4.dat ]; then
  printf "0 1\n1 2\n2 3\n3 .\n4 5\n5 6\n" > data4.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  printf "0 1\n1 2\n2 3\n4 5\n5 6\n" > correct4.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n\n 1.0.0 \n"
printf " Test case: File does not have any missing values. \n"
printf " Expected result: File not edited. \n\n"

cp -f data1.dat test.dat

$PROGRAM test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data1.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.1.0 \n"
printf " Test case: One of TACs has missing value. \n"
printf " Expected result: Correct TAC deleted. \n\n"

cp -f data2.dat correct.dat
cp -f data2.dat test.dat
tacdel correct.dat 3
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n\n 1.2.0 \n"
printf " Test case: All TACs have missing values. \n"
printf " Expected result: Error, and file not edited. \n\n"

cp -f data3.dat test.dat

$PROGRAM test.dat
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch data3.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n\n 2.0.0 \n"
printf " Test case 1: One TAC in file. \n"
printf " Test case 2: One y value is missing. \n"
printf " Expected result: Correct TAC saved. \n\n"

cp -f data4.dat test.dat

$PROGRAM test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct4.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n\n 2.0.1 \n"
printf " Test case 1: One TAC in file. \n"
printf " Test case 2: No missing values. \n"
printf " Expected result: TAC not changed. \n\n"

$PROGRAM test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct4.dat test.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
