#!/bin/bash
#: Title      : test_tacmultx
#: Date       : 2014-10-05
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacmultx$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f test1.dat ] || [ ! -f test1.tac ]; then
  printf "1 2 3\n2 3 4\n3 4 5\n4 5 6\n5 6 7\n" > test1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacformat -format=pmod test1.dat test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test1.tac 1 one
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren test1.tac 2 two
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_test1.dat ] || [ ! -f correct_test1.tac ]; then
  printf "2 2 3\n4 3 4\n6 4 5\n8 5 6\n10 6 7\n" > correct_test1.dat
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacformat -format=pmod correct_test1.dat correct_test1.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren correct_test1.tac 1 one
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  tacren correct_test1.tac 2 two
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Multiply X in simple file format. \n"
printf " Expected result 1: Result file contents are correct. \n"
printf " Expected result 2: Input file can be edited. \n\n"

cp -f test1.dat temp.dat
rm -f output.dat

$PROGRAM temp.dat 2 output.dat 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test1.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM output.dat 0.5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch test1.dat output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===============================================================\n\n"


printf "\n 1.1.0 \n"
printf " Test case: Multiply X in PMOD file format. \n"
printf " Expected result 1: Result file contents are correct. \n"
printf " Expected result 2: Input file can be edited. \n\n"

cp -f test1.tac temp.tac
rm output.tac

$PROGRAM temp.tac 2.0 output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -tacnames=y correct_test1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


$PROGRAM output.tac 0,5
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch test1.tac output.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
