#!/bin/bash
#: Title      : test_tacsplit
#: Date       : 2020-01-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tacsplit$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f data.dft ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n making test data \n"

if [ ! -f data.tac ]; then
  rm -f temp/data.tac
  tacformat -f=PMOD data.dft data.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f temp/data.tac ]; then
  mkdir temp
  cp -f data.tac temp/
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Split DFT file, combine TACs back, and compare to original. \n"
printf " Expected result: TACs can be split and combined back. \n"

rm -f data_voi1_dx_Pl05.dft data_voi1_sin_Pl05.dft data_head__Pl05.dft

$PROGRAM data.dft 
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr combined.dft data_voi1_dx_Pl05.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.dft data_voi1_sin_Pl05.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.dft data_head__Pl05.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y data.dft combined.dft
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f data_voi1_dx_Pl05.dft data_voi1_sin_Pl05.dft data_head__Pl05.dft



printf "\n 1.0.1 \n"
printf " Test case: Split PMOD file, combine TACs back, and compare to original. \n"
printf " Expected result: TACs can be split and combined back. \n"

rm -f data_voi1_dx_Pl05.tac data_voi1_sin_Pl05.tac data_head__Pl05.tac

$PROGRAM data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr combined.tac data_voi1_dx_Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac data_voi1_sin_Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac data_head__Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y data.tac combined.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f data_voi1_dx_Pl05.tac data_voi1_sin_Pl05.tac data_head__Pl05.tac



printf "\n 1.1.0 \n"
printf " Test case: Option -name=filename_nr. \n"
printf " Expected result: TACs can be split and combined back. \n"

rm -f data_1.tac data_2.tac data_3.tac

$PROGRAM -name=filename_nr data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr combined.tac data_1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac data_2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac data_3.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y data.tac combined.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f data_1.tac data_2.tac data_3.tac


printf "\n 1.2.0 \n"
printf " Test case: Option -name=tacid. \n"
printf " Expected result: TACs can be split and combined back. \n"

rm -f voi1_dx_Pl05.tac voi1_sin_Pl05.tac head__Pl05.tac

$PROGRAM -name=tacid data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr combined.tac voi1_dx_Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac voi1_sin_Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac head__Pl05.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y data.tac combined.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f voi1_dx_Pl05.tac voi1_sin_Pl05.tac head__Pl05.tac



printf "\n 1.3.0 \n"
printf " Test case: Option -name=nr. \n"
printf " Expected result: TACs can be split and combined back. \n"

rm -f 1.tac 2.tac 3.tac

$PROGRAM -name=nr data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacadd -ovr combined.tac 1.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac 2.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd combined.tac 3.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -x=y -y=y -xunit=y -yunit=y -tacnames=y data.tac combined.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f 1.tac 2.tac 3.tac



printf "\n 1.4.0 \n"
printf " Test case: Option -keeppath. \n"
printf " Expected result: TACs are split into the same folder as the original file. \n"

rm -f temp/1.tac temp/2.tac temp/3.tac
rm -f temp/data_head__Pl05.tac temp/data_voi1_dx_Pl05.tac temp/data_voi1_sin_Pl05.tac
rm -f 1.tac 2.tac 3.tac
rm -f data_head__Pl05.tac data_voi1_dx_Pl05.tac data_voi1_sin_Pl05.tac

$PROGRAM -keeppath -name=nr temp/data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f temp/1.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f temp/2.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f temp/3.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -keeppath temp/data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f temp/data_head__Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f temp/data_voi1_dx_Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f temp/data_voi1_sin_Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.1 \n"
printf " Test case: Without option -keeppath. \n"
printf " Expected result: TACs are split into the working folder. \n"

rm -f temp/1.tac temp/2.tac temp/3.tac
rm -f temp/data_head__Pl05.tac temp/data_voi1_dx_Pl05.tac temp/data_voi1_sin_Pl05.tac
rm -f temp/1.tac temp/2.tac temp/3.tac
rm -f 1.tac 2.tac 3.tac
rm -f data_head__Pl05.tac data_voi1_dx_Pl05.tac data_voi1_sin_Pl05.tac

$PROGRAM -name=nr temp/data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f 1.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f 2.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f 3.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM temp/data.tac
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f data_head__Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f data_voi1_dx_Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
if [ ! -f data_voi1_sin_Pl05.tac ]; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
