#!/bin/bash
#: Title      : test_tocr
#: Date       : 2014-10-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../tocr$EXT;

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f hrplus_headcurve.txt ] || [ ! -f correct_hrp.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f is129.r ] || [ ! -f correct_is129.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f is130.r ] || [ ! -f correct_is130.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f hrrt1.hc ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_hrrt1_min.cr ] || [ ! -f correct_hrrt1_sec.cr ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f example.head ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 0.1.0 \n"
printf " Test case: No command line options or arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Usage"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "See also"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.1.1 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -wrongoption hrplus_headcurve.txt O-15 output.cr &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-wrongoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.1.2 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM hrplus_headcurve.txt 15O output.cr extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 0.1.3 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM  O-15 output.cr &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM hrplus_headcurve.txt  output.cr &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM hrplus_headcurve.txt  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"



printf "\n 1.0.0 \n"
printf " Test case 1: HR+ headcurve. \n"
printf " Test case 2: Isotope O-15. \n"
printf " Test case 3: Output to simple TAC format, filename given. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.cr

$PROGRAM -f=simple hrplus_headcurve.txt O-15 output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_100.svg -l correct_hrp.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_hrp.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.0.1 \n"
printf " Test case 1: HR+ headcurve, but different file. \n"
printf " Test case 2: Isotope O-15. \n"
printf " Test case 3: Output to simple TAC format, using undocumented, but \n"
printf "              traditional option -format=cr. \n"
printf " Expected result: Correct result. \n\n"

rm -f output.cr

$PROGRAM -format=cr is129.r O-15 output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_101.svg -l correct_is129.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_is129.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.0.2 \n"
printf " Test case 1: HR+ headcurve, again different file. \n"
printf " Test case 2: Isotope C-11. \n"
printf " Test case 3: Output to simple TAC format \n"
printf " Expected result: Correct result. \n\n"

rm -f output.cr

$PROGRAM -format=simple is130.r C-11 output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_102.svg -l correct_is130.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_is130.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 2.0.0 \n"
printf " Test case 1: HRRT headcurve. \n"
printf " Test case 2: Isotope C-11. \n"
printf " Test case 3: Output to simple TAC format \n"
printf " Expected result 1: Correct result, times in min by default. \n"
printf " Expected result 2: cr_duration written in file. \n\n"

rm -f output.cr stdout.txt

$PROGRAM -format=simple hrrt1.hc C-11 output.cr &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval output.cr "cr_duration" "54.9 [min]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_200.svg -l correct_hrrt1_min.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_hrrt1_min.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case 1: HRRT headcurve. \n"
printf " Test case 2: Use option -sec to save in sec. \n"
printf " Test case 3: Output to simple TAC format \n"
printf " Expected result 1: Correct result, times in sec. \n"
printf " Expected result 2: cr_duration written in file. \n\n"

rm -f output.cr stdout.txt

$PROGRAM -format=simple -sec hrrt1.hc C-11 output.cr &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

iftisval output.cr "cr_duration" "3296.2 [sec]"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_201.svg -l correct_hrrt1_sec.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_hrrt1_sec.cr output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case 1: HRRT headcurve. \n"
printf " Test case 2: Output format not specified. \n"
printf " Expected result: Correct result in default format. \n\n"

rm -f output.dat stdout.txt

$PROGRAM hrrt1.hc C-11 output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tac2svg output_210.svg -l correct_hrrt1_min.cr output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=10 -rel=10 -tacnames=n -yunit=y -xunit=y correct_hrrt1_min.cr output.dat
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "format := %s\n" $(tacformat output.dat) > stdout.txt
cat stdout.txt
iftisval stdout.txt "format" "DFT"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-----------------------------------------------------------------\n\n"



printf "\n 3.0.0 \n"
printf " Test case 1: File is not HR+ or HRRT headcurve. \n"
printf " Test case 2: Option -copy is not given. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt

$PROGRAM example.head C-11 output.cr &> stdout.txt
if [ $? -eq 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt "Error" "not identified as HRRT or HR+ countrate file"
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.0.1 \n"
printf " Test case 1: File is not HR+ or HRRT headcurve. \n"
printf " Test case 2: Option -copy is given. \n"
printf " Expected result: File is basically copied with the new name. \n"

rm -f stdout.txt output.cr

$PROGRAM -copy example.head C-11 output.cr &> stdout.txt
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
tacmatch -tacnames=y -xunit=y -yunit=y example.head output.cr
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
