Changes in tpcclib
==================

This is a concise list of changes; commit messages can be found in the
[Git repository](https://gitlab.utu.fi/vesoik/tpcclib.git).

## version 0.8.0 (2023-06-29)

- Removed all support for 32-bit platforms and compilers as unnecessary.
- Removed all support for macOS due to lack of testing platform.
- 4DM TAC CSV files are partially supported by tacRead() in v2.
- Reading NIfTI partially supported in v2. 
- Functions reading NIfTI images do not automatically remove NaNs, but most apps now change those
  to zero with imgNaNs() before further processing.
- Application fit_ppf has new functions GCDF and PE.
- Application fit_pbr has new functions.
- Application htmlgall uses whole window width.
- Added conversion function for UCB-J into applications p2bfuncs, b2plasma, and p2blood in v1.
- Added applications simelli, fit_suri, fitmtrap, imgmtrap, b2ptrap, taccbvp, imgcbvp, imgdelay,
  imgflowm, imgflowd, niinan, tacmove, and hist2svg.
- Bug fix in applications dcmframe and tac2nii.

## version 0.7.9 (2022-12-22)

- Fixed code documentation.
- Bug fix in application taccat.
- Application dftratio works with static an late scan data, and uses frame durations when available.
- Application imgflow can optionally save WSS image.
- Files with missing CR&LF on last line should work in iftRead() and csvRead() in v1.
- Better support for long ROI names in TAC data from small animal pipeline.
- ROI names checked for characters needing encoding when written in XML formats.
- SPM saves a lot of NaNs in NIfTI images; invalid pixel values set to zero when reading NIfTI.
- Updated some tests.
- Added the Halton sequence, a quasi-random low-discrepancy number generator, in libtpcrand in v2.

## version 0.7.8 (2022-02-22)

- Bug fix in applications fit_frtm, fit_rrtm, fit_srtm, and fit_trtm, affecting plots of fitted TACs.
- Bug fix in application lhsol, affecting reversible 3TCM.
- Bug fix in application htmlgall.
- Added applications llsqe3, imglhk1, imgmlist, imgfiltl, imgzavg, maskcloak, and imgaafind.
- Imported application eabaort.
- Added rootsCubic() and rootsQuadratic() in libtpclinopt in v2.
- Added functions in libtpcimgp in v1.
- Less bad support for Siemens DICOM.

## version 0.7.7 (2021-11-25)

- Added applications fit2auc and tac2nii.
- Application dftcat rewritten as taccat, but dftcat kept for now, marked as deprecated.
- Bug fix in application fit_dexp with option -1BL.
- New options in several apps.
- Corrections and additions in libtpcextensions in v2. 
- libtpcfunc in v2 supports more functions, and added mfEvalIntToInf.
- Added iftCopyItems() in libtpcift in v2.
- Added csvCleanSpaces() in libtpccsv in v2.
- parRead() works with CSV files that have extra spaces.
- Large File Support (LFS) extension enabled on all platforms.
- Partial support in v1 libraries and apps for processing very large image files.
- Added label 'slow' to some tests so that those can be omitted with ctest option '-LE slow'.

## version 0.7.6 (2020-06-28)

- Added another conversion function for SMW139 into applications p2bfuncs, b2plasma, and p2blood in v1.
- Added application csvtrps.
- Extended ASCII support for dftFormat() in v1.
- Application paradd works with missing or unsorted region names.
- Added library functions and tests.
- MicroPET: negative CT pixel values retained, and pixel_size_z used if available.
- Build and packaging changes, and documentation changed accordingly.

## version 0.7.5 (2020-05-01)

- Added applications tac2suv, tac2xml, tacjoin, and csvrmcol.
- Application dftcbv rewritten as taccbv, and moved from v1 to v2.
- Added optional functionalities to a few applications.
- Added library functions and tests.
- Global variables in v1 are declared as extern to prevent errors with GCC 10 (thanks to Purusharth Saxena).
- Library functions are declared as extern.
- Applied changes to enable build on macOS Catalina 10.15.4 using HomeBrew llvm/clang.
- Removed deprecated function tacNameMatch() in v2.
- Changed enum weights in v2.
- Added parameter for several CM simulation functions.
- Changes in comments for Doxygen.
- Applications show version information with option --build, too.

## version 0.7.4 (2019-12-21)

- Added applications simdisp, sim_wliv, fit_wliv, fit_blddr, imgswell, and imgidpvc.
- Application tactime rewritten, moved from v1 to v2, and can move TACs to start from peak.
- Gaussian image smoothing functions and imgfiltg application rewritten.
- Added optional functionalities to a few applications.
- Executable library test binaries are not installed.
- Added library functions and tests.
- Enhancements in nonlinear optimization in v2.

## version 0.7.3 (2019-09-19)

- Added applications parmean, svar4tac, and imgfrdyn.
- Application dftweigh is deprecated. Rewritten and renamed to tacweigh.
- Added library functions and tests.
- Added optional functionalities to a few applications.
- Removed some deprecated code.
- Test data and scripts are removed from build folder with make clean. 
- Updated user info in some applications and function documentations.

## version 0.7.2 (2019-09-02)

- Added application fit_disp, fit_wrlv, fit_wpul, and sim_h2o.
- Imported and rewritten application tacslope.
- Application simframe rewritten and moved from v1 to v2.
- Application dftdecay rewritten, renamed to tacdecay, and moved from v1 to v2.
- Prevented string buffer overflows in several source codes.
- Compiler warnings on possible truncation with snprintf() turned off.
- Added libtpcbootstrap in v2; currently empty.
- Added library functions and tests.
- Fixed some minor problems with TAC names.

## version 0.7.1 (2019-07-04)

- Added applications perfrat, iftedit, sim_av, convexpf, convsurg, fit_xexp, fit_xsur, fit_pbr,
  tacmsamp, imglhbdv, imgslope, and imgledif. 
- Added application parai, replacing old application resai.
- Imported and rewritten application yokoi.
- Application tacsetx can add x column to data that originally has only one column.
- Applications imgki and imgdv set threshold based on input.
- Added functions strdelstr(), strTrimLeft(), doubleGEIndex, and doubleGTIndex in 
  libtpcextensions in v2.
- Added MTAC structure and related functions in libtpctac in v2.
- Added function parSetStudyNr() in libtpcpar in v2.
- Added functions fitLine() and fitLinePearson() in libtpclinopt in v2.
- Added optimization criteria in libtpcmodels in v2.
- Added function nlopt1D() in libtpcmodel in v1.
- Added function mtgaPlotSVG() in libtpctacmod in v2.
- NaN accepted in a few additional functions in libtpcimgio in v1.
- Function niftiReadImagedata() supports NIFTI_DT_UNSIGNED_SHORT in libtpcimgio in v1.
- Partial support for Siemens DICOM.
- Function tacSampleXRange() accepts x values with at least one decent y value.
- Open plot symbols are supported in libtpcsvg; function interfaces changed accordingly.
- Bug fix in applications imgadd, eframe, and fit_exp.
- Bug fix in parReadCSV() in libtpcpar in v2.
- Bug fix in sifRead() in libtpcimgio in v1.
- Updated user info in some applications and function documentations.

## version 0.7.0 (2018-12-21)

- Imported applications imgslim and tacpeak.
- Added applications dcftime, imginv, imgdelpl, imgdim, imgcat, imgaumc, pxl2mask, 
  parrenp, parcoll, and parget.
- Application imgmaxfr rewritten and renamed as imgpeak.
- Application imgfiltg can optionally filter only across image planes.
- Changes in UI of img2flat and flat2img.
- Added libtpcecat, libtpcnifti, and libtpcimage in v2; not for production use.
- Partial support for beta-Cube in libtpcdcm.
- Added float versions of functions in libtpcextensions in v2.
- Added functions for element names and symbols in libtpcisotope.c in v2.
- Function imgVoiMaskTAC() in v1 ignores NaNs, affecting img2dft with mask.
- Updates and bug fix in libtpcroi, affecting img2dft with ECAT ROI files.
- Updated user info for imglhk3 and several other executables.
- Several changes to prevent warnings and errors when compiling with GCC 8.1.

## version 0.6.20 (2018-05-16)

- Application absscal updated to work with new GEMS files.
- Imported applications fit_feng, fit_wcdf, lhsol, imglhk3, and imgmove.
- Added application tac4frpl, replacing old application dft2frpl.
- Added application conv1tcm in v2 for simulation and testing.
- Added application liverpv.
- Added applications e63mreg and e63mdel in v1.
- Applications tacformat and parformat, and functions tacWrite() and parWrite() in v2, can write 
  Excel compatible XML format.
- Added option -focus to application imgprofi.
- Changes in ASCII file reading functions in both v1 and v2.
- Fixed bug in dftValidNr() in v1.
- Fixed bug in imgftac with option -integral.
- Added colvolve1D() in libtpccm in v2.
- Added functions qrLH() and bvls() in libtpclinopt.c in v2 and in libtpcmodel in v1.
- Added function parFreeNr() in v1 and v2, and aicSS in v2.
- Improvements in libtpcnlopt in v2.

## version 0.6.19 (2018-02-28)

- Imported applications imgfiltg, dftratio, fit_srtm, fit_rrtm, fit_trtm, and fit_frtm.
- Added applications fvar4tac and var4tac in v2, replacing old applications fvar4dat and var4dat.
- Added applications imgcutof, masklbl, and masksize.
- libtpctac in v2 identifies two Inveon CSV TAC formats, and supports reading of one of those.
- dftReadReference() in v1 has better file format support.
- Functions parCompareTacNames() and parCompareParameterNames() in v2 accept names if the only
  difference is between '-' and '_'.
- When reading ECAT image data, scaled pixels values are checked to be in the range -1E22 - +1E22,
  and if outside the range pixel value is set to zero.
- Fixed a bug in pxlAllocateMore() in libtpcimgio in v1.
- Changes in reading and writing TAC name of result files in v1.
- Application tacadd: can combine several files, and added new option -move.
- Application addvers only refuses to add the same version number again.
- Application imgprofi can save also z profile.
- Application fit_h2o: added option -k2.
- Application imgftac: added new option -integral.
- Application imgmaxp: added new option -wmax.
- Application imgqntls: added new option -abs.
- Application imgthrs can read the limits from files.
- Application imgcalc can read the constant from file, and has new option -abs.
- Application dftinteg checks and, if possible, corrects missing values.
- Added function iftReadValue() in libtpcmisc in v1.
- Added functions imgMaskRegionLabeling() and imgAbs() in libtpcimgp in v1.
- Added function noiseSD4Frame() in libtpcisotope in v2.
- Added functions in libtpcdcm in v2.
- Added most of v2/libtpcdcm contents into v1/libtpcimgio.
- Added functions pxlMakeRoom() and pxlGet() in libtpcimgio in v1.

## version 0.6.18 (2018-01-31)

- Updated documents.
- Added applications tacdelna, tacnames, iftren, and addvers in v2.
- Added application imgqntls in v1.
- Added option -mpt to application imgmaxfr in v1.
- Added option -f to application dftmax in v1.
- Application imgthrs accepts equal limits by widening the range slightly.
- Application fitmbf checks that data does not have missing values.
- Fixed a bug in test for application pbfuncs.
- Change in svg_write_tac() in libtpcsvg to show plots correctly in LibreOffice, as requested
  by Lars Jødal.
- Added function iftReplaceKey() in libtpcift in v2.
- IMG quaterns filled with pixel sizes when reading ECAT 6.3 or 7 in libtpcimgio in v1.
- pixdim[0] set to 1 (previously -1) in imgSetNiftiHeader() in libtpcimgio in v1.
- Renamed v2/libtpctac/tacnames.c to v2/libtpctac/tacname.c
- OpenMP included in all 64-bit builds in `CMakeLists.txt`
- CMake minimum version changed from 2.8.12 to 3.5.1, although new features are not yet applied.

## version 0.6.17 (2017-12-31)

- Imported application pdoc2htm.
- Imported and rewritten application fit_gvar.
- Added application dcmmlist in v2.
- Application e63to7 checks for missing matrices.
- Application eframe gives better error message in case of missing matrices.
- Application tacframe sets time unit, if not known before, 
  and changes file format if writing of original format is not supported.
- Application fitmbf was previously forgotten to be installed. 
- Application fit_h2o saves delay-corrected BTAC without original headers
  which may have had wrong units.
- Application dftavg accepts left and right in addition to dx and sin.
- Added another conversion function for mouse FDG into applications
  p2bfuncs, b2plasma, and p2blood in v1.
- New defines for NIfTI format added to libtpcimgio in v1. 
- NIfTI intent code default from 1007 to 0.
- IMG struct xform parameters default now to NIFTI_XFORM_UNKNOWN and NIFTI_XFORM_SCANNER_ANAT.
- Added functions imgGetMaxFrame() and imgGetMaxTime() in libtpcimgio in v1.
- Added libtpcfcmc in v2; not for production use.
- Added function csvCellReplace() in libtpccsv in v2.
- Added function tacFormatWriteSupported() in libtpctac in v2.
- Added functions in libtpcdcm in v2.
- Added gamma variate bolus plus recirculation function in libtpccurveio in v1.
- Added doubleutil.c from v2 into libtpcmisc in v1.
- Function dftFormat() in v1 checks PMOD format first.
- Function tacRead() in v2 supports QView TAC files.
- Function tpcPrintUsage() in v1 and v2 writes space character into all empty lines.
- Fixed bug in parSelectTACs() and parSelectParameters() in v2.
- Changed to prevent truncation warnings regarding sprintf in Ubuntu gcc 7.2.0.

## version 0.6.16 (2017-09-26)

- Added applications imgfrdif, imgmaxp, maskconj, maskinv, and mask2pxl in v1.
- Added application iftvalc in v2.
- Imported application execlong (previous version written 2004-11-14).
- Added options -w1 and -wf in application imgbfbp in v1.
- Added options -time and -wtime in application imgmaxfr in v1.
- Fixed a bug in application imgthrs which prevented giving negative or zero
  upper absolute threshold.
- Additional functions in libtpcimgio in v1.
- ecat63ReadMainheader() in v1 sets invalid mainheader data_type to VAX_I2.
- CMake configuration file changed to leave out libraries and headers from binary package.

## version 0.6.15 (2017-08-23)

- Fixed a bug in CMake configuration which left out important files from source package.
- Several changes to prevent warnings and errors when compiling with GCC 7.1.
- Added application sim_3tcm in v2, aiming to replace p2t_3c and p2t_v3c.
- Added applications taccuty and fit_dexp in v2.
- Imported application siflist in v1.
- Added applications dcmlhdr and dcmframe in v2; not for production use.
- Fixed RBC-to-plasma ratio function in pbconv.c in v1.
- Fixed a bug in str_token_list_del() in libtpcmisc in v1.
- Fixed a bug in strDateTimeValid() in libtpcextensions in v2.
- Fixed missing close tag in tpcHtmlUsage() in v1 and v2.
- Application p2bfuncs writes ratios with more decimals.
- Application imgbfbp: updated option -savesif.
- Added libtpcdcm in v2; not for production use.
- Added libtpcfileutil in v2.
- Added functions filenameRmFile(), strDateTimeDifference(), doubleMaxIndex(),
  doubleSum(), doubleMean(), doubleSpanPositives(), doubleCSpanPositives(),
  and unitInverse() in libtpcextensions in v2.
- Added functions tacDeleteMissingSamples() and tacWSampleNr in libtpctac in v2.
- Added function textfileReadLines() in libtpcmisc in v1.
- Added function parValueRange() in libtpcpar in v2.
- Added function tacReadModelingInput() in libtpctacmod in v2.
- Added models 1TCM, 2TCM, PAR3TCM and SER3TCM in TPC_MODEL list in v2.
- Added UNIT_ML_PER_ML_SEC in TPC_UNIT list in v2.
- Copied functions strTokenDup() and asciiCommentLine() from v2 into v1.
- Updated functions anaExists() and sifRead() in libtpcimgio in v1.
- Updated function nloptSimplex() in libtpcnlopt in v2.
- Added functions nloptFixedNr() and nloptRemoveEmpties() in libtpcnlopt in v2.
- Function sifWrite() in libtpcimgio in v1 can write trues and weights.
- Additional error messages in v2 libtpcextensions.

## version 0.6.14

- Imported application paucinf in v1.
- Added endian.c in libtpcextensions in v2.

## version 0.6.13

- Added application e63emhdr in v1.
- Imported application simimyoc in v1.
- Imported application sim_mbf (previously b2t_mbf) in v2.
- Imported application fitmbf in v1.
- Imported application imglhdv in v1.
- Added unused blocks into ECAT header structs in libtpcimgio in v1.
- anaReadImagedata() in libtpcimgio can read mask images created in Carimas 2.9.
- Updates and fixes in documentation of several library structs and functions.

## version 0.6.12

- Added applications bigend, fitk5, upet2e7, and upet2sif in v1.
- Updated application dftweigh in v1, reading isotope also from TAC file.
- Updated application metabcor in v1 to retain original time units.
- Function sifRead() in libtpcimgio in v1 does not return error if SIF contains
  only time columns while SIF header tells that data contains four columns.
- Functions studynr_validity_check() and studynr_validity_check2() in libtpcmisc
  in v1 accept more than 5 digits, as long as total length does not exceed 10.
- Updated function upetExists() arguments and return values in v1 libtpcimgio.
- Functions upetGetImageDimensions() and upetReadImagedata() in v1 read 
  preferentially 'time_frames', and only secondarily 'total_frames'.
- Fixed a bug in plotdata() in libtpcmodext in v1: div section was not closed.
- Fixed bugs in application fitdelay in v1: original time units were not
  correctely retained; the optional log info is written also to optional 
  output files, not only to the default output file.
- Fixed a bug in test script for imgshrink.

## version 0.6.11

- Added application sim_pkcp in v2.
- Updated application dftweigh in v1, with new option -wfd.
- Added pharmacokinetic compartment model in libtpcmodels in v2.
- Added some molar units in libtpcextensions in v2.
- Added functions simC2() and simC2_i() in libtpccm in v2.
- Added function parGetParameter() in libtpcpar in v2.
- Added function simSamples() in libtpcli in v2.
- Renamed function sifModerate() to sifModerateTrues() in libtpcimgio in v1.
- Added functions sifWeightByFrames(), sifWeightNorm(), and sifModerateWeights()
  in libtpcimgio in v1.
- Updates and fixes in documentation of several library functions.

## version 0.6.10

- Added application abssbkg in v2, replacing old application blobkg.
- Added application abssexam in v2, replacing old application bloexam.
- Added application abssfch in v2, replacing old application blofch.
- Added application absstime in v2, replacing blotimes and algtimes.
- Added application absszero in v2, replacing old application blozero.
- Added function tacSortByConc in libtpctac in v2.
- Added more contents in library libtpcabss in v2.

## version 0.6.9

- Added applications sifcat, sifisot, and rmcmnts in v2.
- Application taclist in v1 prints also header information with option -ift.
- Application ecat2nii works also when output and input folder is the same.
- Application esetstrt accepts also time difference.
- Added library libtpcabss in v2; work-in-progress.
- Function tacRead() in v2 supports reading of ABSS raw data formats.
- Added variables space_before_eq and space_after_eq into IFT struct in v2.
- Additional argument to function imgReadHeader() in libtpcimgio in v1.
- Added function localtime_r() into v1 and v2 for platforms that do not have it.
- Added some tests to previous test scripts.
- Updates and fixes in user info of several applications.

## version 0.6.8

- Added applications maskeros and maskdila in v1.
- Functions parCompareTacNames() and parCompareParameterNames() in v2 have 
  an additional parameter to require or not require case-sensitive match 
  (before always case-sensitive); applications pardiff and paradd use now 
  case-insensitive matching for TAC and parameter names.
- Renamed some functions in libtpcimgp in v1.
- Renamed mask.c in libtpcidi to idimask.c.
- Added mask.c and imgeval.c in libtpcimgp.
- Added functions imgMaskCount(), imgStructuringElement(), imgMaskErode(),
  and imgMaskDilate() in libtpcimgp in v1.
- MAX_STUDYNR_LEN in v1 and v2 changed from 11 to 255 (excluding space for char 0 in the end); 
  standard study number format still is max 5 letters and 5 digits.
- Added matrix transformation parameters (stored in ECAT 7 image format) to IMG struct.
- Application imgratio retains all ECAT7 image header contents.

## version 0.6.7

- CMake required version is now 2.8.12, previously 2.8.11.
- Added application mkcalhdr in v1, replacing old application with the same name.
- Added application imgprofi in v1, replacing old application eprofile.
- Added application imgbkgrm in v1, replacing old application ebkgrm.
- Application imgbfh2o sets negative perfusion values to zero.
- Application imgadd has new option -x=N and tests.
- Applications flat2img and dft2img in v1 set scan start time.
- Application resmatch in v1 does not return error on different studynr.
- Bug fix in application pxl2tac.
- Function anaReadImagedata() in v1: int variables changed to long ints as
  requested by Peter M Bloomfield. 
- Updates and fixes in user info of several applications.
- Updates in CMake configuration files regarding test procedures.

## version 0.6.6

- Added applications atnmake and img2scn in v1.
- Added application ecatfbp in v1, replacing old application ctifbp.
- Added application ecatmrp in v1, replacing old application mrprec.
- Added application ecatnorm in v1, replacing old application scnnorm.
- Added applications tacadd0 and simboxes in v2.
- Added options -plane and -frame in application lshdr.
- Added library libtpcrec in v1.
- Added functions f_kth_smallest(), fmedian(), fMinMaxFin(), 
  ecat63ReadAttnMatrix(), ecat63CopyMainheader(), and ecat63CopyScanheader() 
  in libtpcimgio in v1.
- Bug fix: ECAT files with some text header fields without terminating null
  caused buffer overflow error.
- fit_h2o does not give error or warning of initial time gap if first concentration is zero.
- Small change in nnls.c in both v1 and v2 to prevent compiler warning.
- Added automatic tests for e63to7 and e7to63.
- Static linking of libgcc and other libraries to be able to use OpenMP
  without external library installation.

## version 0.6.5

- Added applications imgdelfr, imgmaxfr, imgshrink, imgftac, imghist, imgposv, and imgfrsmo in v1.
- Added application imgfsegm in v1, replacing old application eflexseg.
- Added option -minpeaktime in application imgafind in v1.
- Added option -zero in application imgbox in v1.
- Added options -abs and --force in application imgthrs in v1.
- Added option to sort by TAC AUC to application tacsort in v2.
- New name for output image can be given in application imgmask in v1.
- Fixed a bug in option handling in application imghead.
- Fixed and updated user info in several applications.
- Fixed a bug in plot_fit_svg(), plot_fitrange_svg(), and plot_svg() in libtpcmodext in v1.
- Fixed a bug in axis.c in libtpcsvg in v1.
- Added function imgSmoothOverFrames() in libtpcimgp in v1.
- Added functions tacSwapTACCs() and tacSortByAUC() in libtpctac in v2.
- Function imgFrameIntegral() sets frame time based on integration time.
- Function clusterTACs() sets time and calibration units based on the image.
- Code style changes to prevent warnings from gcc 6.2.1.

## version 0.6.4

- Added applications imgbfbp and imgbfh2o in v1.
- Added applications imgflow and imgsrtm in v1.
- Added application arlkup in v2.
- Added application taclkup in v2, replacing old application dftlkup.
- Added application imglkup in v1, replacing old application ecatlkup.
- Added application imgweigh in v1, replacing old application cti2sif.
- Added function tacToPAR() in libtpctacmod in v2.

## version 0.6.3

- Added application tacmean, replacing old applications dfthead and dftstd.
- Application fit_sinf has new option to save dispersion corrected TAC;
  includes the functionality of old application fit_winp.
- Included more data testing in function imgAverageTemplateTAC() in
  libtpcimgp in v1.

## version 0.6.2

- Added applications bfmh2o and bfmsrtm in v2.
- Function bfmRadiowater() in libtpcbfm in v2 uses input frame start and end times if available.
- Function tacReadModelingData in v2 has additional parameter to tell whether
  to cut off extra input samples, because cut-off is not wise in delay time fitting.
- Added function tacWByFreq() in libtpctac in v2.
- Added function tacPlotLineSVG() in libtpctacmod in v2.
- Added function parExamplePerfectBolus() in libtpcpar in v2 to be used in testing.
- Added functions parAllocateWithTAC() and tacAllocateWithPAR() in v2. 
- Added function qrWeightRm() in libtpclinopt in v2, and renamed qr_weight() to qrWeight().
- Added support for gammav in mfEvalY() in v2, and in specific case 
  (f(x)=A(x^B)e^(-x/C); B=1) also in mfEvalInt(), mfEval2ndInt(), and mfEvalFrameY().
- Fixed test for bfmSRTM() in v2.
- Fixed a bug in program parmatch: parameter units no more checked by default. 

## version 0.6.1

- Added function mfEvalFrameY() in libtpcfunc in v2.
- Added function parExampleTTACs() in libtpcpar in v2 to be used in testing.
- Functions mfEvalInt() and mfEval2ndInt() in libtpcfunc in v2 accept functions 
  MF_FENGM2 and MF_FENGM2E, and results are tested against SageMath. 
- Added libtpcmodels in v2, with contents moved from libtpcpar and libtpcfunc.
- Added functions liIntegrate() and liIntegratePET() with tests in v2 libtpcli.
- Tests for functions tacInterpolate() and tacInterpolateInto() in v2 changed. 

## version 0.6.0

- Added CFLAG -mfpmath=sse to prevent fails in simulations and nonlinear
  optimizations, mainly in 32-bit executables.
- Added applications simcirc, o2_p2w, and avgttac in v2.
- Added applications fit_o2bl, sim_o2bl, o2metab, b2t_mo2, fit_sinf, ecalibr, 
  simiart, imgmax, imgthrs, imghead, pxl2tac, imgmask, imgbox, and imgratio in v1.
- Added function doubleGetWithUnit() in libtpcextensions in v2.
- Added function drandExponential() in libtpcrand in v2.
- Added function fitExpDecayNNLS() in libtpcmodel in v1.
- Moved function res2ift() from reslist.c into libtpccurveio in v1.
- Added default values for oxygen metabolism and the functions mo2k1k2() and
  mo2pO2() in libtpcmodel in v1.
- Added function simOxygen() in libtpccm (v2) and in libtpcmodel (v1).
- Added function strIsSpaceOnly() in libtpcextensions in v2, and it is called in
  csvRead() to prevent problems with lines containing only tab and space characters.
- Additional functions in vol.c in v1.
- Added pixel.c in libtpcimgio in v1.
- Applications iftmatch and iftisval in v2 ignore units when testing numerical values.
- Application dftdecay and function dftDecayCorrection() in v1 support hours
  as time unit of TAC data, and dftdecay shows correct unit for halflife.
- Application img2dft supports vrd file and can save TAC in PMOD format.
- Blood-to-plasma conversion function parameters for tracer FMPEP-d2 are
  slightly modified as two additional studies with earlier sample times became available.
- Function regr_line() in v1 accepts NaNs in the data.
- Function fitEval() in v1 libtpccurveio can handle zero eigenvalues with function 331.
- Changes in tgo() parameters in applications fitk3, fitk4, fitk2di, and fit_h2o in v1.
- Changes in drandSeed() in v1 and v2.
- Added Mersenne Twister MT19937 random number generator into v1 and v2.
- Tiny changes in log format written by application fitdelay, and added test script for fitdelay.
- Fixed a bug in isdate2() in libtpcmisc in v1.
- Fixed a bug in p2bfuncs in v1: did not write TAC name in output file.
- Added more tests for simulations in v1.
- User information printed by programs display '- tpcclib' between program name and version number.

## version 0.5.13

- Added applications disp4dft, dftmax, dftdblf, and avgbolus in v1.
- Application dftcat in v1 does not give an error when TACs to be combined start at the same time.
- Application tacframe in v2 gives an error if original file does not contain
  frame start and end times, instead of listing zeroes. If frame times are to
  be saved into file, then frames are guessed from frame mid times like before.
- Globbing of the command line turned on in application tacrange in v2.
- Added readfile.c in libtpcmisc in v1.

## version 0.5.12

- Added application p2bfuncs in v1.
- Better error messages from application tacblend in v2.
- Application fit_hiad in v1: Added tests; Fixed parameter nr with option -hill.
- Bugfix in application tacadd in v2: failing to read existing file does not
  lead to error when option -ovr is used.
- Application absscal in v1 uses now fabs() instead of abs() in two instances.
- Test code in test_iftget.c edited to avoid compiler warnings.

## version 0.5.11

- Functions tacXUnitConvert() and tacYUnitConvert() in v2 return
  TPCERROR_UNKNOWN_UNIT instead of TPCERROR_INCOMPATIBLE_UNIT if both units are unknown; thus 
  calling program may decide not to give error when all data have no units specified.
- Application tocr in v2 gives now a warning, not an error, if time unit is missing.
- Application tacadd in v2 does not give an error if unit is missing in both data files.
- Added fluoride and FMPEP-d2 as tracers into applications b2plasma and p2blood in v1.
- Added application fit_hiad in v1, but not yet tested except in practice.
- Added application tacblend in v2.

## version 0.5.10

- Application pardiff in v2 sets result studynr based on file2, and option
  to calculate difference added.
- Program dftscale in v1: added option --force.
- Added application tacp2f in v2.

## version 0.5.9

- Added application imgcbv in v1.

## version 0.5.8

- Application tac2svg in v1 should not fail if one of TACs does not fit into specified x range.
- Programs fit_ppf, fit_fexp, and metabcor assume that times are in minutes,
  or convert seconds to minutes, when necessary.

## version 0.5.7

- Added application fitk4 in v1.
- Function dftReadModelingData() in v1 sorts TAC data by sample time.

## version 0.5.6

- Added application fit_h2o in v1.


## version 0.5.5

- Added application res2html in v1.
- Fixed a bug in resWriteHTML_table() and resRNameSubfieldExists() in v1.
- Additional argument for functions resWrite() and resWriteHTML() in v1.
- Fixed calculation of integrals of functions 1313 and 1314 in v1 libtpccurveio
  when exponential is zero.
- Started importing applications regbfbp and regbfh2o, not finalized.
- Added functions tacNotNaNs(), tacNthSample(), tacGetIsotope(),
  tacSetIsotope(), tacDecayCorrection(), tacYRangeInXRange(),
  and tacSampleXRange() in v2 libtpctac.
- Added functions mfEvalY() and mfEvalInt() in v2 libtpcfunc;
  started also function mfEval2ndInt() but that is not yet working correctly.
- Added functions liIntegrateHalfFrame() and liFrameMidValue() in v2 libtpcli.
- Added function simC1_i() in v2 libtpccm.
- Added libtpctacmod in v2 with functions tacInterpolate(), tacInterpolateInto(), 
  tacFittime(), tacReadModelingData(), tacReadReference(), and tacPlotFitSVG().
- Added libtpclinopt in v2 with functions qrLSQ(), qr(), and nnls().
- Added libtpcbfm in v2 with functions for computing basis functions for radiowater model and SRTM.
- Additional error messages in v2 libtpcextensions.
- Some function arguments changed to constants in libtpcsvg.

## version 0.5.4

- Added applications sim_rtcm, paradd and pardiff.
- Added bash script for testing application fitk3.
- Added function roinameMatch() in v2 libtpcextensions.
- Added functions parSelectTACs(), parSelectedTACs, parSelectParameters(), parSelectedParameters(),
  parFindParameter(), parAllocateMore(), and parDeleteTAC() in v2 libtpcpar.
- parWriteCSV() and parReadCSV() in v2 write and read model id as a text instead
  of number, because model numbers will change in future versions.
- parWriteFIT() and parReadFIT() in v2 convert model number to old function
  number and vice versa for compatibility with old function fit files.
- Function call _set_output_format(_TWO_DIGIT_EXPONENT) is added to applications
  fitk2, fitk3, fitk2di, and tac2svg.

## version 0.5.3

- Added applications fitk2di, tacsety, parmatch, parsort, and parformat.
- Added bash script for testing application fitk2.
- Added functions csvFindField() and csvSearchField() in v2 libtpccsv.
- Added functions parWriteRES(), parReadRES(), parWriteFIT(), parReadFIT(), and
  parDeletePar() in v2 libtpcpar.
- Functions parRead() and parWrite() in v2 support (deprecated) result and
  fit file formats.
- Added functions iftGetDoubleWithUnit() and tpcYesNo() in v2 libtpcextensions.
- Added functions parFormatIdentify(), parDefaultExtension(), parSortByName(),
  and PAR struct comparison functions in v2 libtpcpar.
- Added integer utility functions in v2 libtpcextensions.
- Added functions for computing gamma distribution function in v2 libtpcfunc.
- Fixed some erroneous function parameter descriptions in v2.

## version 0.5.2

- Application fit_bpr: increased TGO nr.
- Application tacframe, when writing SIF, tries to estimate frame lengths if
  only frame mid times are available.
- Added functions tacIsX() and tacSetX() in v2 libtpctac.
- Additional error messages in v2 libtpcextensions.

## version 0.5.1

- Added application reslist.
- Added bash scripts for testing applications p2t_v3c, p2t_di, and fit_bpr.
- Application tacstudy did not accept option --force; fixed.

## version 0.5.0

- Combined the two versions of tpcclib package, 0.2.8 and 2.0.13 alpha,
  into one package under folders v1 and v2, respectively; this makes building,
  installing, testing and packaging simpler.
- Added applications resdel, dftcbv, heartcor, and dftscale.
- Added application rescoll, but part of tests are still manual.
- Added applications fitk2 and fitk3, but not yet bash test scripts.
- Added bash script for testing application resmatch.
- dftDeleteFrameOverlap() was renamed as dftDeleteFrameOverlap_old().
  New version of dftDeleteFrameOverlap() does not use fixed time limit,
  but instead a relative limit based on the shorter time frame before or after the gap or overlap.
- tacDeleteFrameOverlap() in v2 uses relative instead of fixed time limit.
- Application fitdelay can write data also in PMOD and IF formats.
- dftWrite() in v1 writes comment lines and weights even in PMOD format.
- tacWritePMOD() and thus tacWrite() in v2 save weights in PMOD format.
- Bug fix in application tacadd: tried to check units when creating new file.
- Bash test script for application p2t_3c made and added to CTest.
- Fixed a bug in test script for application patlak.
