#!/bin/bash
#
#  Make user information HTML pages of each of TPCCLIB applications that are found in ./bin folder.
#  These are made by calling each program with option --helphtml.
#  HTML files are placed in ./doc folder. Also a web page ./doc/index.html, containing download
#  links and links to application docs, is created.
#
#  The bin folder is created during TPCCLIB compilation under the build directory. 
#  Accordingly, this script should be copied to the build directory and executed from there
#  with command ./makedoc.sh
#
FILES=*
cd ./bin/
if [ $? -ne 0 ]
then 
  printf "\nError: ./bin folder not found\n" ; exit 1 ; 
fi

if [ -d ../doc ]
then 
  printf "\ndoc folder exists\n"; 
else 
  mkdir ../doc
fi

if [ -e ../doc/index.html ] 
then
  rm ../doc/index.html
fi

printf "<!DOCTYPE html>\n" > ../doc/index.html
printf "<html lang=\"en-GB\">\n" >> ../doc/index.html
printf "<head>\n" >> ../doc/index.html
printf "  <meta charset=\"utf-8\">\n" >> ../doc/index.html
printf "  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n" >> ../doc/index.html
printf "  <title>tpcclib applications</title>\n" >> ../doc/index.html
printf "  <style type=\"text/css\">\n" >> ../doc/index.html
printf "  body { font-family: monospace; font-size: 1em; margin-left: 4em; }\n" >> ../doc/index.html
printf "  ul.container {\n" >> ../doc/index.html
printf "    list-style-type: none;\n" >> ../doc/index.html
printf "    line-height: 2.0;\n" >> ../doc/index.html
printf "    width: 60em;\n" >> ../doc/index.html
printf "    display: table;\n" >> ../doc/index.html
printf "  }\n" >> ../doc/index.html
printf "  li {\n" >> ../doc/index.html
printf "    width: 12em;\n" >> ../doc/index.html
printf "    float: left;\n" >> ../doc/index.html
printf "  }\n" >> ../doc/index.html
printf "  </style>\n" >> ../doc/index.html

printf "  <meta name=\"keywords\" content=\"MODELING, ANALYSIS SOFTWARE, TPCCLIB,\n" >> ../doc/index.html
printf "  TPC, TURKU PET CENTRE, POSITRON EMISSION TOMOGRAPHY\" />\n" >> ../doc/index.html
printf "  <meta name=\"description\" content=\"List of TPC software\" />\n" >> ../doc/index.html

printf "</head>\n" >> ../doc/index.html
printf "<body>\n" >> ../doc/index.html

printf "<!-- THIS HTML FILE IS AUTOMATICALLY CREATED - DO NOT EDIT -->\n" >> ../doc/index.html

printf "<div>\n<h1>List of applications in TPCCLIB</h1>\n" >> ../doc/index.html

printf "<p>Download the listed applications for Windows and Linux from \n" >> ../doc/index.html
printf "<a href=\"https://www.dropbox.com/sh/l22cilo1ze25rj4/RoJiiLh2Q7\">Dropbox</a>, \n" >> ../doc/index.html
printf "<a href=\"https://seafile.utu.fi/d/15843078fb/\">seafile.utu.fi</a>, or\n" >> ../doc/index.html
printf "<a href=\"https://1drv.ms/u/s!At2-B4twnc-loADgwe__5uL5noRq?e=Lc3GRk\">OneDrive</a>.\n" >> ../doc/index.html
printf "</p>\n" >> ../doc/index.html
printf "<p>Download source code from \n" >> ../doc/index.html
printf "<a href=\"https://gitlab.utu.fi/vesoik/tpcclib/-/releases\">GitLab</a>.</p>\n</div>\n" >> ../doc/index.html



printf "<ul class=\"container\">\n" >> ../doc/index.html

for f in $FILES
do
if [[ "$f" != lib* ]]
then
  ls -al $f
  ./$f --helphtml > ../doc/"${f%.*}".html
  printf "  <li><a href=\""${f%.*}".html\">"${f%.*}"</a></li>\n" >> ../doc/index.html
fi
done

printf "</ul>\n" >> ../doc/index.html

printf "<footer><br><br></footer>\n" >> ../doc/index.html
printf "</body>\n" >> ../doc/index.html
printf "</html>\n" >> ../doc/index.html
