Things to do
============

## Library functions ##

- Edit statusSet() in v2 so that it updates previous line number and error code 
  only if function changes.
- Make interpolation and integration functions that consider frames as step
  functions; it will keep frames independent on each other.
- Add support for NIfTI-2, see <http://nifti.nimh.nih.gov/nifti-2/>
- Add __attribute__((fallthrough)); to all switch fallthrough cases, after
  all compilers support that. 
- Errors etc into common struct from all functions?
- Rename all functions, globals, and most structures with tpc*.
- Large File Support (LFS) for all input/output functions.
- Use Halton quasi-random sequence in population optimization and Monte Carlo simulations.
- All image processing functions should work with pixel values that are NaN or Inf,
  because SPM saves NIfTI with NaNs.

## Applications ##

- Move necessary applications from the old TPC C libraries to v1 or v2.
- rescoll should have option to save data as CSV table(s).
- Replace upet2e7 with upet2nii.
- When CT image is saved as NIfTI, use 2-byte short ints to reduce file size.
- Add rFRTM by Mandeville et al (2016).

## Tests

- Use CMakeLists.txt in v2/libtpctac and v1/ecat as templates for others;
  then updated test data and scripts will be automatically updated during build. 
- Test interpolation functions using realistic PET TTAC functions, including gaps and overlaps.
- Test the quantitativity of BF-programs with very wide range of frames.

## Bugs to fix
- Use fixed-width integer types with data formats that are dependent on those.
- Rewrite byte conversion functions to use fixed-width integer types.

## C99 and POSIX ##

- Required: C99 and basic POSIX compatibility. That means also that
  Visual Studio is not supported (I guess).
- Structures can be copied directly with `=` but pointer addresses are copied too
  so pointer contents must be copied with for().
- Structure contents are automatically initiated to 0 and NULL; make sure that it
  works in Windows, Linux, and OS X.
- Forget about own `strncasecmp()`, `strdup()`, etc.
- Structure tag and typedef can (and should) be the same:
  `typedef struct TAC {int a; double b;} TAC;`
- Make sure everything is thread safe in v2.

## Security ##

- Replace all `sprintf()`'s with `snprintf()`, or `(v)asprintf()`
  (from _GNU_SOURCE).
- Replace strncpy() with strlcpy(); automatically NULL terminated.
- Replace strncat() with strlcat(); automatically NULL terminated.
- Replace all `strtok()` calls with something else because `strtok()` is not
  thread-safe (unless it becomes thread-safe with new compiler versions).

