#!/bin/bash
#: Title      : test_fit_frtm
#: Date       : 2022-03-29
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi

PROGRAM=../../fit_frtm$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f rpplasma.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f frames.dat ] || [ ! -f correct_rtcm1.res ] || [ ! -f correct_rtcm2.res ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making data for testing \n"

if [ ! -f sim1.par ]; then
  rm -f rtcm1_full.tac rtcm2_full.tac rtcm_full.tac
  printf "# model := SER3TCM\n" > sim1.par
  printf "Parameters\tK1\tk2\tk3\tk4\tk5\tk6\tVb\tf\tfA\n"     >> sim1.par
  printf "cereb\t0.11\t0.35\t0.0\t0.0\t0\t0\t0\t0\t0\n"        >> sim1.par
  printf "putam\t0.153\t0.489\t0.303\t0.0926\t0\t0\t0\t0\t0\n" >> sim1.par
fi

if [ ! -f rtcm1_full.tac ]; then
  rm -f rtcm1_full.tac rtcm2_full.tac rtcm_full.tac
  sim_3tcm -nosub sim1.par rpplasma.dat rpplasma.dat rtcm1_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f sim2.par ]; then
  rm -f rtcm2_full.tac rtcm_full.tac
  printf "# model := FRTM\n" > sim2.par
  printf "Parameters,R1[unitless],k2[1/min],k3[1/min],BPnd[unitless]\n" >> sim2.par
  printf "putams,1.391,0.489,0.303,3.27\n"        >> sim2.par
fi

if [ ! -f rtcm2_full.tac ]; then
  rm -f rtcm_full.tac
  tacadd -ovr refinput.tac rtcm1_full.tac 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  sim_rtcm -nosub sim2.par refinput.tac rtcm2_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f rtcm_full.tac ]; then
  rm -f rtcm.tac cereb.tac rtcmnor.tac
  tacadd -ovr rtcm_full.tac rtcm2_full.tac rtcm1_full.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy --force rtcm_full.tac sim1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f rtcm.tac ] || [ ! -f rtcmnor.tac ] || [ ! -f cereb.tac ]; then
  simframe rtcm_full.tac frames.dat rtcm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacweigh -wf rtcm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr rtcmnor.tac rtcm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr -move cereb.tac rtcmnor.tac cereb
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg -legend=y rtcm.svg rtcm.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Fit TACs simulated with realistic range of parameters. \n"
printf " Test case 2: Reference inside TTAC file. \n"
printf " Expected result 1: Result file is created, and results are close to correct \n"
printf " Expected result 2: SVG plot is created. \n"
printf " Expected result 3: Fitted TACs should be close to original TACs.\n\n"

rm -f fit_1_0_0.res fit_1_0_0.tac fit_1_0_0.svg

$PROGRAM -fit=fit_1_0_0.tac -svg=fit_1_0_0.svg rtcm.tac cereb 120 fit_1_0_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

if [ ! -f fit_1_0_0.tac ] || [ ! -f fit_1_0_0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.5 -rel=0.5 rtcm.tac fit_1_0_0.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


resmatch -abs=0.05 -header=y -param=y -regions=y -res=1-4 correct_rtcm1.res fit_1_0_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case 1: Fit TACs simulated with realistic range of parameters. \n"
printf " Test case 2: Reference in separate TAC file. \n"
printf " Expected result 1: Result file is created, and results are close to correct \n"
printf " Expected result 2: SVG plot is created. \n"
printf " Expected result 3: Fitted TACs should be close to original TACs.\n\n"

rm -f fit_1_1_0.res fit_1_1_0.tac fit_1_1_0.svg

$PROGRAM -fit=fit_1_1_0.tac -svg=fit_1_1_0.svg rtcmnor.tac cereb.tac 120 fit_1_1_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

if [ ! -f fit_1_1_0.tac ] || [ ! -f fit_1_1_0.svg ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

tacmatch -abs=0.5 -rel=0.5 rtcmnor.tac fit_1_1_0.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


resmatch -abs=0.05 -header=y -param=y -regions=y -res=1-4 correct_rtcm2.res fit_1_1_0.res
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

