#!/bin/bash
#: Title      : test_atnmake
#: Date       : 2016-10-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../atnmake$EXT;
DATAPATH=../ECAT931
BLANK=$DATAPATH/20oct99bl1.scn
TRANS=$DATAPATH/s04065tr2.scn
NORM=$DATAPATH/991005_norm.nrm
ATTN=$DATAPATH/s04065tr2.atn
IMGTRANS=$DATAPATH/s04065tr2.img


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f $BLANK ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $TRANS ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $NORM ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $ATTN ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $IMGTRANS ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n making test data \n"

if [ ! -f s04065tr2_atn.tif ]; then
  img2tif -rb -s $ATTN ./s04065tr2_atn.tif
fi
if [ ! -f s04065tr2_img.tif ]; then
  img2tif -gi -s $IMGTRANS ./s04065tr2_img.tif
fi
if [ ! -f $ATTN.head ]; then
  imghead $ATTN $ATTN.head
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mask128.img ]; then
  simboxes -format=float 128 15 32 5 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 -zoom=1.5 temp.bin mask128.img 15 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f oldtrans.tac ]; then
  img2dft $IMGTRANS mask128.img oldtrans.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Make attenuation file from actual measured data. \n"
printf " Test case 2: Save also transmission image with different settings. \n"
printf " Expected result 1: Files are created. \n"
printf " Expected result 2: Attenuation data are close to previously made. \n"
printf " Expected result 3: Transmission image is close to previously made. \n\n"

rm -f output_tr2.atn output_tr2.img output.head

$PROGRAM -dim=128 -zoom=1.5 $BLANK $TRANS $NORM output_tr2.atn output_tr2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output_tr2.atn output_atn.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -gi -s output_tr2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imghead output_tr2.atn output.head
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=3 $ATTN.head output.head
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -frames=no -abs=0.1 -rel=18 $ATTN output_tr2.atn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


imgmatch -frames=no -abs=0.15 -rel=1 $IMGTRANS output_tr2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft output_tr2.img mask128.img newtrans.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=no -abs=0.0005 -rel=5 oldtrans.tac newtrans.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


