#!/bin/bash
#: Title      : test_e63mdel
#: Date       : 2018-03-13
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e63mdel$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"

printf "\n making test data \n"

if [ ! -f ecat63.img ]; then
  simcirc -format=float 32 16 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 temp.bin temp.img 1 1 32 32
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgmove temp.img -6 -2
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # Make mask extend over 15 image planes
  imgadd -x=15 frame.img temp.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # Use the mask image to create dynamic image
  ecatcat frame.img frame.img frame.img frame.img frame.img frames.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  ecatcat frames.img frames.img frames.img frames.img ecat63.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Remove the last matrix from dynamic ECAT 6.3 image file. \n"
printf " Expected result: Matrix disappears from matrix list. \n\n"

rm -f output.img output.txt output.ift
lmlist ecat63.img > ecat63.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift ecat63.txt pl fr > ecat63.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



$PROGRAM ecat63.img 20 15 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmlist output.img > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.txt pl fr > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift sampleNr 299
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift value[2][299] 15
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[2][300] 15
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output.ift value[3][299] 19
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift value[3][300] 20
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.0.1 \n"
printf " Test case: Remove the first matrix from the previously made file. \n"
printf " Expected result: Matrix disappears from matrix list. \n\n"

rm -f output2.img output2.txt output2.ift

$PROGRAM output.img 1 1 output2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmlist output2.img > output2.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output2.txt pl fr > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output2.ift sampleNr 298
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


iftisval output2.ift value[2][4] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift value[2][5] 1
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output2.ift value[3][1] 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval output2.ift value[3][298] 19
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


