#!/bin/bash
#: Title      : test_e63to7
#: Date       : 2016-11-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../e63to7$EXT;
PROGRAM2=../../e7to63$EXT;
DATAPATH=../ECAT931
IMAG=$DATAPATH/s04065dy2.img
SCAN=$DATAPATH/s04065dy2.scn


printf "\n\n"
printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f $IMAG ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $SCAN ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


if [ ! -f mask128.img ]; then
  simboxes -format=float 128 15 32 5 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 -zoom=1.5 temp.bin mask128.img 15 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f old.tac ]; then
  img2dft $IMAG mask128.img old.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Convert ECAT 6.3 image to ECAT 7 format. \n"
printf " Expected result 1: File contents are correct. \n"
printf " Expected result 2: File can be converted back to ECAT 6.3. \n\n"

rm -f output.v output.tac output.img

$PROGRAM $IMAG output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v mask128.img output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=3 old.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgunit -uc=kBq/cc output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $IMAG output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM2 output.v output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $IMAG output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Convert ECAT 6.3 sinogram to ECAT 7 format. \n"
printf " Expected result: File can be converted back to ECAT 6.3. \n\n"

rm -f output.s output.tac output.scn

$PROGRAM $SCAN output.s
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $SCAN output.s
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM2 output.s output.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=5 $SCAN output.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n\n"
printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
