#!/bin/bash
#: Title      : test_ecalibr
#: Date       : 2016-03-22
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecalibr$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f calfiles/000112 ] || [ ! -f calfiles/000114 ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f calfiles/7-SEP-1993 ] || [ ! -f calfiles/11-OCT-1993 ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n ok \n"

if [ ! -f test.img ] || [ ! -f test.roi ]; then
  rm -f temp.dat test?.img
  echo 1 1 2 3 4 >  temp.dat
  echo 3 2 3 4 5 >> temp.dat
  dft2img -Scanner=931 -Dim=4 temp.dat temp.img test.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd test.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img temp.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=counts test.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt test.img 2000-01-13 12:20:05
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=Ga-68 test.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

printf "\n ok \n"

if [ ! -f test.cal ]; then
  printf "160322\n" > test.cal
  printf "0.500\n" >> test.cal
  printf "0.501\n" >> test.cal
  printf "0.502\n" >> test.cal
  printf "0.503\n" >> test.cal
  printf "0.504\n" >> test.cal
  printf "0.505\n" >> test.cal
  printf "0.506\n" >> test.cal
  printf "0.507\n" >> test.cal
  printf "0.508\n" >> test.cal
  printf "0.509\n" >> test.cal
  printf "0.510\n" >> test.cal
  printf "0.511\n" >> test.cal
  printf "0.512\n" >> test.cal
  printf "0.513\n" >> test.cal
  printf "0.514\n" >> test.cal
  printf "___________\n" >> test.cal
  printf "0.507\n" >> test.cal
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Just image filename as argument. \n"
printf " Expected result: Current calibration listed. \n\n"

rm -f stdout.txt output.dat
$PROGRAM test.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scan_start_time "2000-01-13 12:20:05"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt calibration_units "ECAT counts"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt isotope "Ga-68"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -p test.img test.roi output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Automatic determination of correct calibration file. \n"
printf " Expected result 1: Correct calibration file selected. \n"
printf " Expected result 2: Image contents changed, correct units. \n\n"

rm -f stdout.txt output2.dat
cp -f test.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM test2.img calfiles &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -p test2.img test.roi output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=1 -rel=10 output.dat output2.dat
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt calibrationfile "calfiles/000112"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt
imgunit test2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt unit "kBq/mL"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Calibration can be removed. \n"
printf " Expected result: Resulting image is the same as before. \n\n"

rm -f stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM test2.img 0 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=0.1 test.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt
imgunit test2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt unit "counts"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Calibration can be removed so that BR correction remains. \n"
printf " Expected result: Resulting image has only BR correction. \n\n"

rm -f stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM test2.img calfiles &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test2.img 1 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgcalc test.img : 0.891 temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=0.1 temp.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt
imgunit test2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt unit "counts"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: Calibration filename given. \n"
printf " Test case 2: Calibration file from uCi time. \n"
printf " Expected result 1: Specified calibration file used. \n"
printf " Expected result 2: Image units still in kBq/mL. \n\n"


rm -f stdout.txt output2.dat
cp -f test.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM -d test2.img calfiles/11-OCT-1993 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt calfile "calfiles/11-OCT-1993"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f stdout.txt
imgunit test2.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval stdout.txt unit "kBq/mL"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Scan time after beginning of 1997. \n"
printf " Expected result: Correct image values with BR correction. \n\n"

rm -f stdout.txt output2.dat
cp -f test.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM test2.img test.cal &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft -p=1 test2.img test.roi output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp.dat output.dat Pl001
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc --force temp.dat x 500 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# branching ratio of Ge-68
taccalc --force temp.dat : 0.891 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -yunit=n -abs=0.1 -rel=0.1 temp.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft -p=15 test2.img test.roi output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp.dat output.dat Pl015
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc --force temp.dat x 514 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# branching ratio of Ge-68
taccalc --force temp.dat : 0.891 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -yunit=n -abs=0.1 -rel=0.1 temp.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Scan time before beginning of 1997. \n"
printf " Expected result: Correct image values without BR correction. \n\n"

rm -f stdout.txt output2.dat
cp -f test.img test2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt test2.img 1996-01-13 12:20:05
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM test2.img test.cal &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft -p=1 test2.img test.roi output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp.dat output.dat Pl001
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc --force temp.dat x 500 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -yunit=n -abs=0.1 -rel=0.1 temp.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft -p=14 test2.img test.roi output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp.dat output.dat Pl014
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc --force temp.dat x 513 temp.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -yunit=n -abs=0.1 -rel=0.1 temp.dat output2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
 

printf "\n\n"
printf "=====================================================================\n"
printf "error testing\n"
printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -nonexistingoption test.img &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-nonexistingoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM test.img calfiles extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM nofile.img calfiles &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot open file nofile.img"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.1 \n"
printf " Test case: Calibration file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM test.img nofile.cal &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "cannot read calibrations in nofile.cal."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
