#!/bin/bash
#: Title      : test_ecatcat
#: Date       : 2014-09-07
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecatcat$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f o2frame.dat ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f orig.sif ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f plane1.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi
if [ ! -f plane2.dft ]; then
  printf "Failed: required file does not exist.\n"
  exit 1
fi

if [ ! -f orig.img ] || [ ! -f orig.v ]; then

  dft2img -zoom=2 -dim=32 plane1.dft plane1.img plane1.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -zoom=2 -dim=32 plane2.dft plane2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd orig.img plane1.img plane2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt orig.img 2003-12-04 15:00:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 orig.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -P orig.img plane1.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e63to7 -c=o orig.img orig.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n ECAT 6 \n\n"


printf "\n1.0.0 Split two first and two last frames into separate files \n"
printf "      and then combine them back \n\n"

rm -f orig1.img orig2.img catenated.img
esplit orig.img 1-2 1-999 orig1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esplit orig.img 3-4 1-999 orig2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM orig1.img orig2.img catenated.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P catenated.img plane1.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.05 -rel=1 orig.dft catenated.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n1.1.0 Put one halflife difference into scan start times and repeat \n\n"

esetstrt orig1.img 2003-12-04 15:00:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt orig2.img 2003-12-04 15:20:24
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif -p=1 -f=1 orig2.img temp1.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe orig2.img o2frame.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
# Divide last part by 2, because ecatcat should correct it back
imgcalc orig2.img : 2 orig2b.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif -f=1 -p=1 orig2.img temp2.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f catenated2.img
$PROGRAM orig1.img orig2b.img catenated2.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -f=3 -p=1 catenated2.img catenated2.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P catenated2.img plane1.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.05 -rel=1 orig.dft catenated2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"


printf "\n ECAT 7 \n\n"


printf "\n2.0.0 Split two first and two last frames into separate files \n"
printf "      and then combine them back \n\n"

rm -f orig1.v orig2.v catenated.v
esplit orig.v 1-2 1-999 orig1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esplit orig.v 3-4 1-999 orig2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM orig1.v orig2.v catenated.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P catenated.v plane1.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.05 -rel=1 orig.dft catenated.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n2.1.0 Put one halflife difference into scan start times and repeat \n\n"

esetstrt orig1.v 2003-12-04 15:00:00
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
esetstrt orig2.v 2003-12-04 15:20:24
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe orig2.v o2frame.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
# Divide last part by 2, because ecatcat should correct it back
imgcalc orig2.v : 2 orig2b.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

rm -f catenated2.v
$PROGRAM orig1.v orig2b.v catenated2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -f=3 -p=1 catenated2.v catenated2.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft -P catenated2.v plane1.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -abs=0.05 -rel=1 orig.dft catenated2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

