#!/bin/bash
#: Title      : test_ecatfbp
#: Date       : 2016-10-30
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecatfbp$EXT;

DATAPATH=../ECAT931
SCAN1=$DATAPATH/s04065dy2.scn
ATTN1=$DATAPATH/s04065tr2.atn
NORM1=$DATAPATH/991005_norm.nrm
IMAG1=$DATAPATH/s04065dy2.img


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f dynamic.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f $SCAN1 ] || [ ! -f $ATTN1 ] || [ ! -f $NORM1 ] || [ ! -f $IMAG1 ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f s04065dy2.tif ] || [ ! -f oldhead1.tac ]; then
  img2tif -rb -s $IMAG1 ./s04065dy2.tif
  imghead -keepnegat $IMAG1 oldhead1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f petmask.img ] || [ ! -f plmask.img ]; then
  simboxes -format=float 128 15 32 5 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 -zoom=1.5 temp.bin petmask.img 15 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  simboxes -format=float 128 15 128 1 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 -zoom=1.5 temp.bin plmask.img 15 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f old1.tac ] || [ ! -f oldsum1.tac ] || [ ! -f oldplanes1.tac ]; then
  img2dft $IMAG1 petmask.img old1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg oldtac1.svg -l old1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imginteg -avg $IMAG1 0 0 oldsum1.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft oldsum1.img petmask.img oldsum1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s oldsum1.img oldsum1.tif 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2dft $IMAG1 plmask.img oldplanes1.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n making more test data \n"



if [ ! -f image2D.img ] || [ ! -f image3D.img ] || [ ! -f image4D.img ]; then
  rm -f image3D.scn image4D.scn
  simcirc -format=float 128 64 circle.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  flat2img -scanner=931 circle.bin image_p01.img 1 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  cp -f image_p01.img image2D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  2 image_p02.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  3 image_p03.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  4 image_p04.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  5 image_p05.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  6 image_p06.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  7 image_p07.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  8 image_p08.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  9 image_p09.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 10 image_p10.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 11 image_p11.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 12 image_p12.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 13 image_p13.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 14 image_p14.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 15 image_p15.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3D.img image_p??.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image3D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  ecatcat image3D.img image3D.img image3D.img image3D.img image3D.img image3D.img image3D.img image4D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image4D.img dynamic.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image4D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image2D.scn ] || [ ! -f image3D.scn ] || [ ! -f image4D.scn ]; then
  img2scn image3D.img image3D.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image3D.scn scan3D.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  esplit image3D.scn 1 1 image2D.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image2D.scn scan2D.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  img2scn image4D.img image4D.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mask2D.img ] || [ ! -f mask3D.img ]; then
  simcirc -format=float 128 50 mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=931 mask.bin mask_p01.img 1 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  cp -f mask_p01.img mask2D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -gr -s mask2D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcalc mask_p01.img x  2 mask_p02.img
  imgcalc mask_p01.img x  3 mask_p03.img
  imgcalc mask_p01.img x  4 mask_p04.img
  imgcalc mask_p01.img x  5 mask_p05.img
  imgcalc mask_p01.img x  6 mask_p06.img
  imgcalc mask_p01.img x  7 mask_p07.img
  imgcalc mask_p01.img x  8 mask_p08.img
  imgcalc mask_p01.img x  9 mask_p09.img
  imgcalc mask_p01.img x 10 mask_p10.img
  imgcalc mask_p01.img x 11 mask_p11.img
  imgcalc mask_p01.img x 12 mask_p12.img
  imgcalc mask_p01.img x 13 mask_p13.img
  imgcalc mask_p01.img x 14 mask_p14.img
  imgcalc mask_p01.img x 15 mask_p15.img

  imgadd mask3D.img mask_p??.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -gr -s mask3D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Reconstruct static 2D image. \n"
printf " Expected result: Resulting image contents are close to correct. \n\n"

rm -f output2D.img
img2dft image2D.img mask2D.img image2D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d3 -dim=128 -filter=hann image2D.scn output2D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output2D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output2D.img mask2D.img output2D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift image2D.tac
taclist -ift output2D.tac
tacmatch -abs=0.1 -rel=2 image2D.tac output2D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: Reconstruct static 3D image. \n"
printf " Expected result: Resulting image contents are close to correct. \n\n"

rm -f output3D.img
img2dft image3D.img mask3D.img image3D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -d3 -dim=128 image3D.scn output3D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output3D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output3D.img mask3D.img output3D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=2 image3D.tac output3D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

imghead image3D.img correct.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead output3D.img output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=1 -abs=0.1 correct.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Reconstruct dynamic 3D image. \n"
printf " Expected result: Resulting image contents are close to correct. \n\n"

rm -f output4D.img
img2dft image4D.img mask3D.img image4D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -dim=128 -filter=hann image4D.scn output4D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output4D.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output4D.img mask3D.img output4D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=2 image4D.tac output4D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: 1.5x zooming and increased cutoff. \n"
printf " Expected result: Resulting image contents are close to correct. \n\n"

rm -f output2Dz.img
img2dft image2D.img mask2D.img image2D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -zoom=1.5 -dim=128 -cutoff=0.5 -filter=hann image2D.scn output2Dz.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output2Dz.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output2Dz.img mask2D.img output2Dz.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=2 image2D.tac output2Dz.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case: 2.45x zooming with decimal comma. \n"
printf " Expected result: Resulting image contents are close to correct. \n\n"

rm -f output2Dzz.img
img2dft image2D.img mask2D.img image2D.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -zoom=2,45 image2D.scn output2Dzz.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output2Dzz.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output2Dzz.img mask2D.img output2Dzz.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.1 -rel=2 image2D.tac output2Dzz.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Odd image dimension. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -dim=127 image2D.scn output.img &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid image dimension."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"




printf "\n 2.0.0 ---- Real dynamic ECAT931 PET data. \n\n"
printf " Test case 1: Attenuation and normalization, no dead-time correction here. \n"
printf " Test case 2: FBP reconstruction with 1.5x zoom and cutoff 0.5. \n"
printf "              Reconstruction program makes dead-time correction.\n"
printf " Test case 3: Decay correction. \n"
printf " Test case 4: Calibration. \n"
printf " Expected result: Similar image created than with old SUN FBP software.\n\n"

rm -f output1.img output1.scn output1.tac stdout.txt

ecatnorm -dtc=no $SCAN1 $NORM1 $ATTN1 output1.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -zoom=1.5 -cutoff=0.5 -dim=128 output1.scn output1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgdecay -dd output1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output1.img output1.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

ecalibr output1.img ../ECAT931/calfiles/991005 > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
# This only if automatic search
#iftisval stdout.txt calibrationfile "../ECAT931/calfiles/971014"
#if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
#printf "\n ok \n"

imghead -keepnegat output1.img head1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg head1.svg -s oldhead1.tac -l head1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft output1.img plmask.img planes1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=yes -mt="Planes" planes1.svg -s oldplanes1.tac -l planes1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc planes1.tac : oldplanes1.tac planesrat1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=yes -mt="Ratio new-to-old" planesrat1.svg planesrat1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imginteg -avg output1.img 0 0 outputsum1.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft outputsum1.img petmask.img outputsum1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taccalc outputsum1.tac : oldsum1.tac new_per_old1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif -rb -s outputsum1.img outputsum1.tif 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=1 oldsum1.tac outputsum1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


img2dft output1.img petmask.img output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg outputtac1.svg -l output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -abs=0.001 -rel=1 old1.tac output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


