#!/bin/bash
#: Title      : test_ecatnorm
#: Date       : 2016-11-02
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../ecatnorm$EXT;
DATAPATH=../ECAT931
SCAN=$DATAPATH/s04065dy2.scn
ATTN=$DATAPATH/s04065tr2.atn
NORM=$DATAPATH/991005_norm.nrm

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f dynamic.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

if [ ! -f $SCAN ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $ATTN ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f $NORM ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n making test data \n"

if [ ! -f image3D.img ] || [ ! -f image4D.img ]; then
  simcirc -format=float 128 64 circle.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  flat2img -scanner=931 circle.bin image_p01.img 1 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  2 image_p02.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  3 image_p03.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  4 image_p04.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  5 image_p05.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  6 image_p06.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  7 image_p07.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  8 image_p08.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x  9 image_p09.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 10 image_p10.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 11 image_p11.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 12 image_p12.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 13 image_p13.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 14 image_p14.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image_p01.img x 15 image_p15.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3D.img image_p??.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  ecatcat image3D.img image3D.img image3D.img image3D.img image3D.img image3D.img image3D.img image4D.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe image4D.img dynamic.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image3D.scn ] || [ ! -f image4D.scn ]; then
  img2scn image3D.img image3D.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2scn image4D.img image4D.scn
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f normalization.nrm ]; then
  imgcalc image3D.img : image3D.img temp.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc temp.img : image3D.img normalization.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2scn normalization.img normalization.nrm
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s normalization.nrm
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Normalize a static sinogram. \n"
printf " Expected result: Sinogram is written. \n\n"

rm -f output3D.scn
$PROGRAM image3D.scn normalization.nrm output3D.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output3D.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Normalize a dynamic 3D sinogram. \n"
printf " Expected result: Sinogram is written. \n\n"

rm -f output4D.scn
$PROGRAM -dtc=yes image4D.scn normalization.nrm output4D.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output4D.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case: Remove normalization from a static sinogram. \n"
printf " Expected result: Sinogram is written. \n\n"

rm -f output3Db.scn
$PROGRAM -rm -dtc=no output3D.scn normalization.nrm output3Db.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=10 -rel=5 image3D.scn output3Db.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Remove normalization from a dynamic 3D sinogram. \n"
printf " Expected result: Sinogram is written. \n\n"

rm -f output4Db.scn
$PROGRAM -rm -dtc=yes output4D.scn normalization.nrm output4Db.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=5000 -rel=5 image4D.scn output4Db.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: All corrections to an ECAT931 sinogram. \n"
printf " Test case 2: Removal of corrections. \n"
printf " Expected result 1: Corrected sinogram is written. \n"
printf " Expected result 2: Uncorrected sinogram is written. \n\n"


rm -f corrected.scn uncorrected.scn
$PROGRAM -dtc=yes $SCAN $NORM $ATTN corrected.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s $SCAN original_scn.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s corrected.scn corrected_scn.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -rm -dtc=yes corrected.scn $NORM $ATTN uncorrected.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s uncorrected.scn uncorrected_scn.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=5 -rel=1 $SCAN uncorrected.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


