#!/bin/bash
#: Title      : test_imglhk2d
#: Date       : 2021-12-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imglhk2d$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for  %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f radiowater_lvcav.fit ] || [ ! -f radiowater.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "\n simulating test data \n"

if [ ! -f radiowater_abss.bld ] || [ ! -f radiowater_pv.bld ]; then
  rm -f liver.tac liver.nii radiowater_mix?.bld
  fit2dat -c=0,420,1 radiowater_lvcav.fit radiowater_abss.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  liverpv -i=0.01 radiowater_abss.bld 2.17 radiowater_pv.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f radiowater_mix1.bld ] || [ ! -f radiowater_mix2.bld ]; then
  rm -f liver.tac liver.nii
  liverinp radiowater_pv.bld radiowater_abss.bld 0.8 radiowater_mix1.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  liverinp radiowater_pv.bld radiowater_abss.bld 0.6 radiowater_mix2.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f liver.tac ]; then
  rm -f liver.nii
  b2t_h2o -voiname=Mask-1 -nosub radiowater_mix1.bld 400 0.9 1 20 1 liver.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  b2t_h2o -add -voiname=Mask-2 -nosub radiowater_mix2.bld 400 0.9 1 20 1 liver.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  b2t_h2o -add -voiname=Mask-3 -nosub radiowater_abss.bld 100 0.9 1 5 1 liver.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
  b2t_h2o -add -voiname=Mask-4 -nosub radiowater_pv.bld 300 0.9 1 15 1 liver.bld
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

  simframe --silent liver.bld radiowater.sif liver.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi

  tac2svg -legend=y simulated_tacs.svg -l radiowater_*.bld -b liver.tac
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi

if [ ! -f liver.nii ]; then
  tac2nii liver.tac 16 16 16 liver.nii mask.nii
  if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Estimate parameters using full data length. \n"
printf " Expected result: Parametric images are calculated. \n\n"

rm -f k1a.nii k1b.nii k2.nii vba.nii vbb.nii

$PROGRAM radiowater_abss.bld radiowater_pv.bld liver.nii k1a.nii k1b.nii vba.nii vbb.nii k2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft k1a.nii mask.nii k1a.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vba.nii mask.nii vba.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft k1b.nii mask.nii k1b.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft vbb.nii mask.nii vbb.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft k2.nii mask.nii k2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "\n--- Results for K1A: \n"
taclist k1a.tac
printf "\n--- Results for K1B: \n"
taclist k1b.tac
printf "\n--- Results for VbA: \n"
taclist vba.tac
printf "\n--- Results for VbB: \n"
taclist vbb.tac
printf "\n--- Results for k2: \n"
taclist k2.tac



printf "=====================================================================\n"
printf "  All passed!\n"
printf "=====================================================================\n"
exit 0
