#!/bin/bash
#: Title      : test_img2dft
#: Date       : 2018-12-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../img2dft$EXT;
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f frames.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f plasma.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f Brain_ROIs.nii ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi


if [ ! -f simple.v ] || [ ! -f simple.roi ] || [ ! -f simple.tac ]; then
  # make 4x4 image
  printf "1 2 2 3\n"  > m.dat
  printf "3 4 4 5\n" >> m.dat
  printf "4 5 5 6\n" >> m.dat
  printf "6 7 7 8\n" >> m.dat
  asc2flat m.dat flat.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT -zoom=2 flat.bin simple.v 1 1 4 4
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # make 4 2x2 rois
  printf "*original.v 1.000000 2.000000 16842753 3 0 0 0 0 0 0 1 reg1 ///0 5\n" > simple.roi
  printf "0 0 1 0 1 1 0 1 0 0 \n" >> simple.roi
  printf "*original.v 1.000000 2.000000 16842753 3 0 2 0 0 0 0 2 reg2 ///0 5 \n" >> simple.roi
  printf "0 0 1 0 1 1 0 1 0 0  \n" >> simple.roi
  printf "*original.v 1.000000 2.000000 16842753 3 0 0 2 0 0 0 3 reg3 ///0 5 \n" >> simple.roi
  printf "0 0 1 0 1 1 0 1 0 0  \n" >> simple.roi
  printf "*original.v 1.000000 2.000000 16842753 3 0 2 2 0 0 0 4 reg4 ///0 5 \n" >> simple.roi
  printf "0 0 1 0 1 1 0 1 0 0  \n" >> simple.roi
  # make correct TAC file for comparison
  printf "start[seconds]\tend[unknown]\treg1__Pl001\treg2__Pl001\treg3__Pl001\treg4__Pl001\n" > simple.tac
  printf "0.00000\t0.00000\t2.500e+00\t3.500e+00\t5.500e+00\t6.500e+00\n" >> simple.tac
fi



if [ ! -f orig.dft ] || [ ! -f origf.dft ]; then

  printf "\n\n Creating orig.dft \n\n"

  p2t_3c -nosub plasma.dat 0.050 0.025 0 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.100 0 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.250 0 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd -ovr orig.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub plasma.dat 0.200 0.050 0.005 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.200 0.200 0.005 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.200 0.800 0.005 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  p2t_3c -nosub plasma.dat 0.050 0.025 0.05 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.100 0.05 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.050 0.250 0.05 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft 1

  p2t_3c -nosub plasma.dat 0.500 0.050 0.5 0 0 0 tis1.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.500 0.400 0.5 0 0 0 tis2.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  p2t_3c -nosub plasma.dat 0.500 0.800 0.5 0 0 0 tis3.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis1.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis2.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacadd orig.dft tis3.dft 1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "\n\n Creating origf.dft \n\n"
  simframe orig.dft frames.dat origf.dft F-18
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
# dftrenpl origf.dft
  tacren origf.dft 0 tac#
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi

if [ ! -f ecat63.img ]; then
  printf "\n\n Creating ecat63.img \n\n"
  dft2img -scanner=adv -dim=128 -zoom=1.5 origf.dft ecat63.img ecat63.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 -dc ecat63.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb ecat63.img
fi

if [ ! -f ecat7.v ]; then
  printf "\n\n Creating ecat7.v \n\n"
  dft2img -scanner=HR+ -dim=64 -zoom=1,5 origf.dft ecat7.v ecat7.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 -dc ecat7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb ecat7.v
fi


if [ ! -f mask.v ]; then
  rm -f mask.dat
  printf "0 1 2 3 4 5 6 7 8 9 10 11 12\n" > mask.dat
  printf "\n\n Creating mask.v \n\n"
  dft2img -scanner=HR+ -dim=64 -zoom=1,5 mask.dat mask.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  dft2img -scanner=HR+ -dim=64 -zoom=1,5 -tpl=mask.v origf.dft ecat7m.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=F-18 -dc ecat7m.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mask.vrd ]; then
  printf "corner1 := 1 59 1\n"  > mask.vrd
  printf "corner2 := 6 63 1\n" >> mask.vrd
fi


if [ ! -f analyze/analyze.img ]; then
  printf "\n\n Creating analyze image \n\n"
  cp -f ecat7.v analyze.v
  ecat2ana -o=analyze -sif analyze.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nifti/nifti.img ]; then
  printf "\n\n Creating NIfTI image \n\n"
  cp -f ecat7.v nifti.v
  ecat2nii -o=nifti -sif nifti.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_niftimask.tac ]; then
  printf "start[minutes]	end[unknown]	Mask-1	Mask-2	Mask-3	Mask-4	Mask-5	Mask-6	Mask-7	Mask-8	Mask-9	Mask-10	Mask-11	Mask-12\n"  > correct_niftimask.tac
  printf "0.0	0.5	1.0	2.0	3.0	4.0	5.0	6.0	7.0	8.0	9.0	10	11	12.0\n" >> correct_niftimask.tac
  printf "0.5	1.0	1.1	2.2	3.3	4.4	5.5	6.6	7.7	8.8	9.9	11	12.1	13.2\n" >> correct_niftimask.tac
  printf "1.0	4.0	1.2	2.4	3.6	4.8	6.0	7.2	8.4	9.6	10.8	12	13.2	14.4\n" >> correct_niftimask.tac
  printf "4.0	8.0	1.3	2.6	3.9	5.2	6.5	7.8	9.1	10.4	11.7	13	14.3	15.6\n" >> correct_niftimask.tac
  printf "8.0	12.0	1.2	2.4	3.6	4.8	6.0	7.2	8.4	9.6	10.8	12	13.2	14.4\n" >> correct_niftimask.tac
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 Calculate ROI TACs from ECAT 6 image \n\n"

rm -f ecat63.dft
$PROGRAM ecat63.img ecat63.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y ecat63.svg -s origf.dft -l ecat63.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 origf.dft ecat63.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 Calculate ROI TACs from ECAT 7 image \n\n"

rm -f ecat7.dft
$PROGRAM ecat7.v ecat7.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y ecat7.svg -s origf.dft -l ecat7.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 origf.dft ecat7.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 Calculate simple trace ROIs from simple ECAT 7 image \n\n"

rm -f output.tac
$PROGRAM simple.v simple.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=n -y=y -xunit=n -yunit=n -abs=0.001 -rel=0.01 simple.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 Calculate ROI TACs from Analyze image \n\n"

rm -f analyze.dft
$PROGRAM analyze/analyze ecat7.roi analyze.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y analyze.svg -s origf.dft -l analyze.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=n -abs=0.1 -rel=1 origf.dft analyze.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 Calculate ROI TACs from NIfTI image \n"
printf "       and save as PMOD file. \n\n"

rm -f nifti.dft
$PROGRAM nifti/nifti ecat7.roi nifti.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y nifti.svg -s origf.dft -l nifti.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=n -abs=0.1 -rel=1 origf.dft nifti.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n 2.0.0 Calculate mask TACs from ECAT 7 image \n\n"

rm -f ecat7m.dft
$PROGRAM ecat7m.v mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y ecat7m.svg -s origf.dft -l ecat7m.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -xunit=y -yunit=y -abs=0.1 -rel=1 origf.dft ecat7m.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n\n"
printf " Test case 1: NIfTI brain ROI 3D mask. \n"
printf " Test case 2: Dynamic NIfTI image. \n"
printf " Expected result: Correct ROI TACs saved in PMOD format. \n\n"

imgcalc Brain_ROIs.nii x 1.1 temp1.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgcalc Brain_ROIs.nii x 1.2 temp2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgcalc Brain_ROIs.nii x 1.3 temp3.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgcat test.nii Brain_ROIs.nii temp1.nii temp2.nii temp3.nii temp2.nii
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

printf "24/10/2018 23:42:09 5 4 1 Test F-18\n" > test.sif
printf "  0  30 0 0\n" >> test.sif
printf " 30  60 0 0\n" >> test.sif
printf " 60 240 0 0\n" >> test.sif
printf "240 480 0 0\n" >> test.sif
printf "480 720 0 0\n" >> test.sif

$PROGRAM test.nii Brain_ROIs.nii niftimask.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y niftimask.svg niftimask.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacmatch correct_niftimask.tac niftimask.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 3.0.0 Calculate VRD TAC from ECAT 7 image \n\n"

rm -f vrd.tac
$PROGRAM ecat7m.v mask.vrd vrd.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y vrd.svg -s origf.dft -l vrd.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacadd -ovr temp.dft origf.dft tac09
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
tacmatch -tacnames=n -xunit=y -yunit=y -abs=0.1 -rel=1 temp.dft vrd.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

