#!/bin/bash
#: Title      : test_imgdim
#: Date       : 2019-11-30
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdim$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f image3d.v ] || [ ! -f image4v.v ]; then
  rm -f *.img ana/* nii/*
  # frame 1
  printf "1 1 1 1\n"  > f.dat
  printf "1 1 1 1\n" >> f.dat
  printf "1 0 1 1\n" >> f.dat
  printf "1 1 1 1\n" >> f.dat
  printf "1 1 1 1\n" >> f.dat
  # frame 2
  printf "2 2 2 2\n" >> f.dat
  printf "2 2 2 2\n" >> f.dat
  printf "2 1 2 2\n" >> f.dat
  printf "2 2 2 2\n" >> f.dat
  printf "2 2 2 2\n" >> f.dat
  # frame 3
  printf "3 3 3 4\n" >> f.dat
  printf "3 3 3 3\n" >> f.dat
  printf "3 2 3 3\n" >> f.dat
  printf "3 3 3 3\n" >> f.dat
  printf "2 2 2 2\n" >> f.dat
  # frame 4
  printf "4 4 4 4\n" >> f.dat
  printf "4 4 5 4\n" >> f.dat
  printf "4 3 4 4\n" >> f.dat
  printf "4 4 4 4\n" >> f.dat
  printf "4 4 4 4\n" >> f.dat
  # frame 5
  printf "4 4 4 4\n" >> f.dat
  printf "4 4 4 4\n" >> f.dat
  printf "4 1 4 4\n" >> f.dat
  printf "4 4 4 4\n" >> f.dat
  printf "4 4 4 4\n" >> f.dat
  # frame 6
  printf "3 3 3 2\n" >> f.dat
  printf "2 2 2 2\n" >> f.dat
  printf "3 0 3 4\n" >> f.dat
  printf "2 2 2 3\n" >> f.dat
  printf "2 2 2 3\n" >> f.dat
  # construct dynamic image
  asc2flat f.dat flat.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT flat.bin image3d.v 1 6 4 5
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  # construct 4D image
  imgadd -x=7 image4d.v image3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f image4d.img ]; then
  e7to63 -c=o image4d.v image4d.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f ana/image4d.img ] || [ ! -f ana/image4d.hdr ]; then
  rm -f ana/*
  ecat2ana -sif -o=ana image4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nii/image4d.nii ] || [ ! -f nii/image4d.sif ]; then
  rm -f nii/*
  ecat2nii -sif -o=nii image4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case 1: Print all dimensions. \n"
printf " Test case 2: ECAT 7. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" "$OUTPUT"
if [ "$OUTPUT" != "4 5 7 6" ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Print all dimensions. \n"
printf " Test case 2: ECAT 6. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM image4d.img)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "$OUTPUT" != "4 5 7 6" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Print all dimensions. \n"
printf " Test case 2: Analyze. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM ana/image4d)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "$OUTPUT" != "4 5 7 6" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: Print all dimensions. \n"
printf " Test case 2: NIfTI. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM nii/image4d)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "$OUTPUT" != "4 5 7 6" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Print x dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -x image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 4 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Print y dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -y image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 5 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case: Print z dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -z image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 7 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.3 \n"
printf " Test case: Print frame number. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -t image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 6 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case 1: Print pixel sizes in all dimensions. \n"
printf " Test case 2: ECAT 7. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -size image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" "$OUTPUT"
if [ "$OUTPUT" != "78 78 1.21875" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Print pixel sizes in all dimensions. \n"
printf " Test case 2: ECAT 6. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -size image4d.img)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "${OUTPUT}" != "78 78 1.21875" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case 1: Print pixel sizes in  all dimensions. \n"
printf " Test case 2: Analyze. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -size ana/image4d)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "${OUTPUT}" != "78 78 1.21875" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.3 \n"
printf " Test case 1: Print pixel sizes in  all dimensions. \n"
printf " Test case 2: NIfTI. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -size nii/image4d)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ "${OUTPUT}" != "78 78 1.21875" ]; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 2.1.0 \n"
printf " Test case: Print pixel size in x dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -x -size image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 78 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Print pixel size in y dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -size -y image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 78 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.2 \n"
printf " Test case: Print pixel size in z dimension. \n"
printf " Expected result: Correct output. \n\n"

OUTPUT="$($PROGRAM -z -size image4d.v)"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok with '%s'\n" $OUTPUT
if [ ! ${OUTPUT} == 1.21875 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


