#!/bin/bash
#: Title      : test_imgmax
#: Date       : 2016-06-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgmax$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f test_dyn.tac ] || [ ! -f test_dyn2.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f dynamic1.v ]; then
  dft2img -scanner=HR+ -zoom=2 -dim=8 test_dyn.tac dynamic1.v dynamic1.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 dynamic1.v dynamic1.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f ana/dynamic1.*
  rmdir ana
  ecat2ana -sif -o=ana dynamic1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f nifti/dynamic1.*
  rmdir nifti
  ecat2nii -sif -o=nifti dynamic1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic2.v ]; then
  dft2img -scanner=HRRT -zoom=2.5 -dim=10 test_dyn2.tac dynamic2.v dynamic2.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 dynamic2.v dynamic2.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f ana/dynamic2.*
  rmdir ana
  ecat2ana -sif -o=ana dynamic2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f nifti/dynamic2.*
  rmdir nifti
  ecat2nii -sif -o=nifti dynamic2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: No options, one image file. \n"
printf " Test case 2: ECAT 7 format. \n"
printf " Expected result: Correct max value reported. \n\n"

rm -f output.txt
$PROGRAM dynamic1.v > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt max 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.1 \n"
printf " Test case: No options, one image file. \n"
printf " Test case 2: ECAT 6 format. \n"
printf " Expected result: Correct max value reported. \n\n"

rm -f output.txt
$PROGRAM dynamic1.img > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt max 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.2 \n"
printf " Test case: No options, one image file. \n"
printf " Test case 2: NIfTI format. \n"
printf " Expected result: Correct max value reported. \n\n"

rm -f output.txt
$PROGRAM nifti/dynamic1 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt max 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.0.3 \n"
printf " Test case: No options, one image file. \n"
printf " Test case 2: Analyze format. \n"
printf " Expected result: Correct max value reported. \n\n"

rm -f output.txt
$PROGRAM ana/dynamic1 > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt max 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: No options, two image files. \n"
printf " Expected result: Correct max value of all images reported. \n\n"

rm -f output.txt
imgcalc dynamic1.v x 2 dynamic1b.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM dynamic1.v dynamic1b.v > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt "Maximum of all files" 200
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: No options, over two image files with wildcard. \n"
printf " Expected result: Correct max value of all images reported. \n\n"

rm -f output.txt

$PROGRAM dynamic*.v > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt "Maximum of all files" 200
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.0 \n"
printf " Test case: Option to report minimum insted of maximum. \n"
printf " Expected result: Correct min value of all images reported. \n\n"

rm -f output.txt

$PROGRAM -min dynamic*.v > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt "Minimum of all files" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Option to report both min and max. \n"
printf " Expected result: Correct min and max value of all images reported. \n\n"

rm -f output.txt

$PROGRAM -both dynamic*.v > output.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt "Minimum of all files" 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.1 output.txt "Maximum of all files" 200
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


