#!/bin/bash
#: Title      : test_imgmaxp
#: Date       : 2018-02-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgmaxp$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f image3d.v ] || [ ! -f image4v.v ]; then
rm -f image4d.v
# frame 1
printf "1 1 1 1\n"  > f.dat
printf "1 1 1 1\n" >> f.dat
printf "1 0 1 1\n" >> f.dat
printf "1 1 1 1\n" >> f.dat
# frame 2
printf "2 2 2 2\n" >> f.dat
printf "2 2 2 2\n" >> f.dat
printf "2 1 2 2\n" >> f.dat
printf "2 2 2 2\n" >> f.dat
# frame 3
printf "3 3 3 4\n" >> f.dat
printf "3 3 3 3\n" >> f.dat
printf "3 2 3 3\n" >> f.dat
printf "3 3 3 3\n" >> f.dat
# frame 4
printf "4 4 4 4\n" >> f.dat
printf "4 4 5 4\n" >> f.dat
printf "4 3 4 4\n" >> f.dat
printf "4 4 4 4\n" >> f.dat
# frame 5
printf "4 4 4 4\n" >> f.dat
printf "4 4 4 4\n" >> f.dat
printf "4 1 4 4\n" >> f.dat
printf "4 4 4 4\n" >> f.dat
# frame 6
printf "3 3 3 2\n" >> f.dat
printf "2 2 2 2\n" >> f.dat
printf "3 0 3 4\n" >> f.dat
printf "2 2 2 3\n" >> f.dat
# construct dynamic image
asc2flat f.dat flat.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
flat2img -scanner=HRRT flat.bin image3d.v 1 6 4 4
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
img2tif -rb -s image3d.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image4v.v ]; then
  imgcalc image3d.v . 0.333333 p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image3d.v . 0.666667 p3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image4d.v p1.v image3d.v p3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s image4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct_max3d.dat ]; then
  printf "3,2,1,4\n"  > correct_max3d.dat
fi
if [ ! -f correct_max4d.dat ]; then
  printf "3,2,2,4\n"  > correct_max4d.dat
fi
if [ ! -f correct_max4df3.dat ]; then
  printf "4,1,2,3\n"  > correct_max4df3.dat
fi
if [ ! -f correct_min4df3.dat ]; then
  printf "2,3,1,1\n"  > correct_min4df3.dat
fi



if [ ! -f imagew3d.v ]; then

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 9 9 9 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 9 0 9 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 9 9 9 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> tmp.dat
  asc2flat tmp.dat tmp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT tmp.bin p2.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgadd imagew3d.v p1.v p1.v p1.v p2.v p1.v p2.v p1.v p1.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb imagew3d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_maxw3d.dat ]; then
  printf "5,14,5,1\n"  > correct_maxw3d.dat
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"




printf "\n 1.0.0 \n"
printf " Test case: max of dynamic image into file. \n"
printf " Expected result: Correct coordinates. \n\n"

rm -f output.dat

$PROGRAM image3d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_max3d.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case: max of 4D image into file. \n"
printf " Expected result: Correct coordinates. \n\n"

rm -f output.dat

$PROGRAM image4d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_max4d.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: range that cover whole image. \n"
printf " Expected result: Correct coordinates. \n\n"

printf "corner1 := 1,1,1,1\n"  > full.vrd
printf "corner2 := 4,4,3,6\n" >> full.vrd

rm -f output.dat

$PROGRAM -vrdfile=full.vrd image4d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_max4d.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: range that covers only first 3 frames. \n"
printf " Expected result: Correct coordinates. \n\n"

printf "corner1 := 1,1,1,1\n"  > f1-3.vrd
printf "corner2 := 4,4,3,3\n" >> f1-3.vrd

rm -f output.dat

$PROGRAM -vrdfile=f1-3.vrd image4d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_max4df3.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.2 \n"
printf " Test case: min from range that covers only first 3 frames. \n"
printf " Expected result: Correct coordinates. \n\n"

rm -f output.dat

$PROGRAM -min -vrdfile=f1-3.vrd image4d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_min4df3.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"






printf "\n 1.2.0 \n"
printf " Test case: weighted max of static 3D image into file. \n"
printf " Expected result: Correct coordinates. \n\n"

rm -f output.dat

$PROGRAM -wmax imagew3d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_maxw3d.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.1 \n"
printf " Test case: range that covers important parts of image. \n"
printf " Expected result: Correct coordinates. \n\n"

printf "corner1 := 2,10,3,1\n"  > w3d.vrd
printf "corner2 := 7,16,7,1\n" >> w3d.vrd

rm -f output.dat

$PROGRAM -vrdfile=w3d.vrd -wmax imagew3d.v output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_maxw3d.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


