#!/bin/bash
#: Title      : test_imgposv
#: Date       : 2016-09-28
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgposv$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f image2D1.v ] || [ ! -f image3D.v ]; then
  rm -f image.bin image3D.v
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n"  > image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  printf "+0 +0 +0 +0 +0 +0 +0 +0\n" >> image.dat
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image2D1.v 1 1 8 8 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image2D2.v ] || [ ! -f image3D.v ]; then
  rm -f image.bin image3D.v
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n"  > image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  printf "+1 +1 +1 +1 +1 +1 +1 +1\n" >> image.dat
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image2D2.v 1 1 8 8 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image2D3.v ] || [ ! -f image3D.v ]; then
  rm -f image.bin image3D.v
  printf "%s1 +0 +1 %s1 +0 +1 %s1 +0\n" '-' '-' '-'  > image.dat
  printf "%s2 +0 +2 %s2 +0 +2 %s2 +0\n" '-' '-' '-' >> image.dat
  printf "%s3 +0 +3 %s3 +0 +3 %s3 +0\n" '-' '-' '-' >> image.dat
  printf "%s4 +0 +4 %s4 +0 +4 %s4 +0\n" '-' '-' '-' >> image.dat
  printf "%s5 +0 +5 %s5 +0 +5 %s5 +0\n" '-' '-' '-' >> image.dat
  printf "%s6 +0 +6 %s6 +0 +6 %s6 +0\n" '-' '-' '-' >> image.dat
  printf "%s7 +0 +7 %s7 +0 +7 %s7 +0\n" '-' '-' '-' >> image.dat
  printf "%s8 +0 +8 %s8 +0 +8 %s8 +0\n" '-' '-' '-'>> image.dat
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image2D3.v 1 1 8 8 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image3D.v ]; then
  imgadd image3D.v image2D1.v image2D2.v image2D3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: ECAT7 2D image with all zeroes. \n"
printf " Expected result: Correct percentage calculated. \n\n"

rm -f output.ift
$PROGRAM image2D1.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift positive_volume_percentage 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: ECAT7 2D image with all nonzeroes. \n"
printf " Expected result: Correct percentage calculated. \n\n"

rm -f output.ift
$PROGRAM image2D2.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift positive_volume_percentage 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: ECAT7 2D image with whatever values. \n"
printf " Expected result: Correct percentage calculated. \n\n"

rm -f output.ift
$PROGRAM image2D3.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift positive_volume_percentage 25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: ECAT7 3D image with whatever values. \n"
printf " Expected result: Correct percentage calculated. \n\n"

rm -f output.ift
$PROGRAM image3D.v output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift positive_volume_percentage 41.6667
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: Result written in stdout. \n"
printf " Expected result: Correct percentage calculated. \n\n"

rm -f output.ift
$PROGRAM image3D.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.01 output.ift positive_volume_percentage 41.6667
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption image3D.v  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM image3D.v output.ift extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.v output.ift &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


