#!/bin/bash
#: Title      : test_imgunit
#: Date       : 2014-09-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgunit$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

if [ ! -f test.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_2_3_1a.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_2_3_1b.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_2_4_2.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_2_4_3.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f ecat931.img ] || [ ! -f ecat931.dft ] ; then
  printf "\n\n Creating ecat931.img \n\n"
  dft2img -scanner=931 -dim=8 test.dat ecat931.img ecat931.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt ecat931.img 2006-04-20 11:32:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft ecat931.img ecat931.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi

if [ ! -f hrplus.v ] || [ ! -f hrplus.dft ] ; then
  printf "\n\n Creating hrplus.v \n\n"
  dft2img -scanner=HR+ -dim=8 test.dat hrplus.v hrplus.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt hrplus.v 2006-04-20 11:32:00
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft hrplus.v hrplus.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n done. \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n0.1.0 Unknown option \n\n"

rm -f stdout.txt
$PROGRAM -stupidoption *.v *.img &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"


printf "\n===================================================================\n"
printf "    Use cases"
printf "\n===================================================================\n"

printf "\n1.0.0 Report units, which are unknown in original images \n\n"

printf "\n ECAT7 \n\n"

rm -f stdout.txt
$PROGRAM hrplus.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "unit" "unknown"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT6 \n\n"

rm -f stdout.txt
$PROGRAM ecat931.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "unit" "unknown"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n"

printf "\n===================================================================\n"

printf "\n1.1.0 Trying to convert unknown units leads to error. \n\n"

printf "\n ECAT7 \n\n"

cp -f hrplus.v temp.v
rm -f stdout.txt
$PROGRAM -uc=kBq/mL temp.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "cannot convert unknown unit."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n ECAT6 \n\n"

cp -f ecat931.img temp.img
rm -f stdout.txt
$PROGRAM -uc=kBq/mL temp.img &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "cannot convert unknown unit."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n1.2.1 Use option -us to set only unknown units to kBq/ml. \n\n"

rm -f stdout.txt
$PROGRAM -us=kBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit 'unknown' replaced by 'kBq/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "unit 'unknown' replaced by 'kBq/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n1.2.2 Try to use again option -us; \n"
printf "      must fail this time because now unit exists \n\n"

rm -f stdout.txt
$PROGRAM -us=nCi/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit 'kBq/mL' is not replaced"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "unit 'kBq/mL' is not replaced"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n1.2.3 But setting units again with -u must work \n\n"

rm -f stdout.txt
$PROGRAM -u=Bq/mL temp.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit 'kBq/mL' replaced by 'Bq/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -u=nCi/mL temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "unit 'kBq/mL' replaced by 'nCi/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n1.2.4 Convert data to kBq/ml using option -uc \n\n"

rm -f stdout.txt
$PROGRAM -uc=kBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit 'Bq/cc' converted to 'kBq/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "unit 'nCi/mL' converted to 'kBq/ml'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft temp.v hrplus.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y correct_2_3_1b.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

img2dft temp.img ecat931.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y correct_2_3_1a.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.2.5 Warning if trying to convert data to same unit \n\n"

rm -f stdout.txt
$PROGRAM -uc=kBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit is already kBq/ml"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.img "unit is already kBq/ml"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n1.2.6 Conversion to Bq/cc must work \n\n"

rm -f stdout.txt
$PROGRAM -uc=Bq/cc temp.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt temp.v "unit 'kBq/mL' converted to 'Bq/cc'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft temp.v hrplus.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y correct_2_4_2.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"

printf "\n1.3.0 Conversion to and from MBq/ml \n\n"

cp -f hrplus.v temp.v
cp -f ecat931.img temp.img
cp -f hrplus.dft cor1.dft
cp -f ecat931.dft cor2.dft

rm -f stdout.txt
tacunit -yset=kBq/mL cor1.dft cor2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -u=kBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

tacunit -yconv=MBq/ml cor1.dft cor2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -uc=MBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft temp.v hrplus.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y cor1.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
img2dft temp.img ecat931.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y cor2.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


tacunit -yconv=kBq/ml cor1.dft cor2.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -uc=kBq/mL temp.v temp.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft temp.v hrplus.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y cor1.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
img2dft temp.img ecat931.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -y=y -yunit=y cor2.dft temp.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

