#!/bin/bash
#: Title      : test_pxl2tac
#: Date       : 2016-06-13
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../pxl2tac$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f correct_100.tac ] || [ ! -f correct_120.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_130.tac ] || [ ! -f correct_200.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f dynamic.sif ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"


if [ ! -f image.dat ] || [ ! -f image.v ]; then
rm -f image.bin image.v
printf "1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1\n"  > image.dat
printf "1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1\n" >> image.dat
printf "1 2 3 4 5 6 7 8 9 8 7 6 5 4 3 2\n" >> image.dat
printf "1 2 2 2 2 2 2 2 2 2 2 2 2 2 2 1\n" >> image.dat
printf "1 3 3 3 4 4 4 5 5 5 6 6 4 2 2 1\n" >> image.dat
printf "1 3 4 5 7 9 9 9 9 9 9 8 5 4 3 1\n" >> image.dat
printf "1 6 6 6 6 6 6 6 6 6 6 6 6 6 6 1\n" >> image.dat
printf "1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 3 1 1 1 1 1\n" >> image.dat
printf "1 1 1 1 1 1 1 1 1 1 4 2 1 1 1 1\n" >> image.dat
printf "2 0 0 0 0 0 0 0 1 2 5 3 1 0 0 2\n" >> image.dat
printf "3 0 0 0 0 0 0 1 3 5 7 5 1 0 0 3\n" >> image.dat
printf "4 0 0 0 0 0 1 2 4 7 8 6 2 0 0 4\n" >> image.dat
printf "5 0 0 0 0 1 3 4 5 8 9 7 3 0 0 5\n" >> image.dat
printf "6 0 0 0 1 2 3 5 7 9 9 8 6 3 0 6\n" >> image.dat
printf "7 7 8 9 9 9 9 9 9 9 9 9 9 9 8 7\n" >> image.dat
fi

if [ ! -f image.v ] || [ ! -f image3d.v ] || [ ! -f dynamic.v ]; then
  rm -f dynamic.v
  asc2flat image.dat image.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT image.bin image.v 1 1 16 16 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgunit -u=Bq/cc image.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc image.v x 2 image2.v
  imgcalc image.v x 3 image3.v
  imgcalc image.v x 4 image4.v
  imgcalc image.v x 5 image5.v
  imgcalc image.v + 1 image6.v
  imgcalc image.v - 1 image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v image.v image2.v image3.v image4.v image5.v image6.v image7.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f dynamic.v ] || [ ! -f pixels2.lst ]; then
  ecatcat image.v image2.v image3.v image4.v image5.v image6.v image7.v dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  eframe dynamic.v dynamic.sif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  printf "2,2,1,0\n"   >  pixels2.lst
  printf "2,4,1,0\n"   >> pixels2.lst
  printf "9,6,1,0\n"   >> pixels2.lst
  printf "11,9,1,0\n"  >> pixels2.lst
  printf "7,13,1,0\n"  >> pixels2.lst
  printf "11,14,1,0\n" >> pixels2.lst
  printf "15,14,1,0\n" >> pixels2.lst
fi


if [ ! -f mask.dat ] || [ ! -f mask.v ]; then
rm -f mask.bin mask.v
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mask.dat
printf "0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane2
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane3
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane4
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane5
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane6
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
# plane7
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat
printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mask.dat

fi

if [ ! -f mask.bin ] || [ ! -f mask.v ]; then
  asc2flat mask.dat mask.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mask.bin mask.v 7 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f pixels.lst ]; then
  printf "2,2,1\n"   >  pixels.lst
  printf "2,4,2\n"   >> pixels.lst
  printf "9,6,3\n"   >> pixels.lst
  printf "11,9,4\n"  >> pixels.lst
  printf "7,13,5\n"  >> pixels.lst
  printf "11,14,6\n" >> pixels.lst
  printf "15,14,7\n" >> pixels.lst
fi


if [ ! -f mask.vrd ]; then
  printf "corner1 := 8,14,1\n"  >  mask.vrd
  printf "corner2 := 9,14,7\n" >>  mask.vrd
fi




printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Pixel list file. \n"
printf " Test case 2: Static image. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_100.tac
$PROGRAM -d3 image3d.v output_100.tac pixels.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_100.tac output_100.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Mask file. \n"
printf " Test case 2: Static image. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_110.tac
$PROGRAM -d3 image3d.v output_110.tac mask.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_100.tac output_110.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.2.0 \n"
printf " Test case 1: VRD file. \n"
printf " Test case 2: Static image. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_120.tac
$PROGRAM -d3 image3d.v output_120.tac mask.vrd
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_120.tac output_120.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Option -positives. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_130.tac
$PROGRAM -positives image3d.v output_130.tac pixels.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_130.tac output_130.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.0 \n"
printf " Test case 1: Dynamic image. \n"
printf " Test case 2: Pixel list contains frames set to zero. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_200.tac
$PROGRAM dynamic.v output_200.tac pixels2.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg -legend=y output_200.svg output_200.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_200.tac output_200.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case 1: Dynamic image. \n"
printf " Test case 2: Option -positives. \n"
printf " Expected result: Correct values from correct pixels extracted. \n\n"

rm -f output_201.tac
$PROGRAM -positives dynamic.v output_201.tac pixels2.lst
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.001 -rel=0.1 correct_200.tac output_201.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"







printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


