#!/bin/bash
#: Title      : test_flat2img
#: Date       : 2018-10-23
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../flat2img$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

if [ ! -f original.dat ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f image1.dat ] || [ ! -f image1.inf ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f image2.dat ] || [ ! -f image2.inf ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f image3.dat ] || [ ! -f image3.inf ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f scan1.dat ] || [ ! -f scan1.inf ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f scan1.dat ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi

if [ ! -f correct_image2_transposed.v ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_image3z.v ] ; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi


if [ ! -f original.v ] || [ ! -f original.img ]; then
  printf "\n making original images \n"
  dft2img -zoom=2 -scanner=HRRT -dim=32 original.dat plane1.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc plane1.v x 2 plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd original.v plane1.v plane2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgdecay -i=C-11 original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt original.v 2007-03-06 13:02:23
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2dft -P original.v original.roi original.dft
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 original.v original.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf " done. \n\n"
fi

if [ ! -f image1.bin ]; then
  printf "\n making binary flat file \n"
  asc2flat image1.dat image1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f image2.bin ]; then
  printf "\n making binary flat file \n"
  asc2flat image2.dat image2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f image3.bin ]; then
  printf "\n making binary flat file \n"
  asc2flat image3.dat image3.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f scan1.bin ]; then
  printf "\n making binary flat file \n"
  asc2flat scan1.dat scan1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f scan2.bin ]; then
  printf "\n making binary flat file \n"
  asc2flat scan2.dat scan2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 option -bins \n\n"

printf "\n without option \n\n"

rm -f stdout.txt
$PROGRAM -d2 image1.bin image1.v 1 1 40 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt binNr "40"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n error with image \n\n"

rm -f stdout.txt
$PROGRAM -d2 -bins=192 image1.bin image1.v 1 1 40 40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "bin nr can be used only with sinograms."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n binNr too small \n\n"

rm -f stdout.txt
$PROGRAM -d2 -bins=19 scan1.bin scan1.scn 2 3 29 40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "binNr should be larger than dimx."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n binNr is ok with ECAT6 2D sinogram \n\n"

rm -f stdout.txt scan1.scn scan2.scn
$PROGRAM -d2 scan2.bin scan2.scn 2 3 35 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt
$PROGRAM -d2 -bins=35 scan1.bin scan1.scn 2 3 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt dimx 35
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt binNr 29
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch scan1.scn scan2.scn
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n binNr is ok with Ecat7 3D sinogram \n\n"

rm -f stdout.txt scan1.s scan2.s
$PROGRAM -d2 scan2.bin scan2.s 2 3 35 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

rm -f stdout.txt
$PROGRAM -d2 -bins=35 scan1.bin scan1.s 2 3 29 40 > stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt dimx 35
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt binNr 29
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -frames=n scan1.s scan2.s
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n bin_nr is now even (previously odd): ok \n\n"

rm -f stdout.txt scan1.s
$PROGRAM -d2 -bins=34 scan1.bin scan1.s 3 2 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt dimx 34
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt binNr 29
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "---------------------------------------------------------------------\n"

printf "\n 1.1.0 option -scanner \n\n"

printf "\n without option \n\n"

rm -f stdout.txt
$PROGRAM -d2 image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n invalid scanner \n\n"
rm -f stdout.txt
$PROGRAM -d2 -scanner=stupid image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt  Error "invalid option '-scanner=stupid'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n set scanner to GE Advance \n\n"

rm -f stdout.txt image2.v mhdr.txt
$PROGRAM -d2 -scanner=Advance image2.bin image2.v 2 5 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "12096"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr image2.v > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "55"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n the same but with sinogram \n\n"

rm -f stdout.txt scan1.scn mhdr.txt
$PROGRAM -d2 -scanner=Advance scan1.bin scan1.scn 3 2 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "12096"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr scan1.scn > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "55"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n set scanner to CTI ECAT 931 \n\n"

rm -f stdout.txt image2.v mhdr.txt
$PROGRAM -d2 -scanner=931 image2.bin image2.v 2 5 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "12"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr image2.v > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "60.0826"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n the same but with sinogram \n\n"

rm -f stdout.txt scan1.scn mhdr.txt
$PROGRAM -d2 -scanner=931 scan1.bin scan1.scn 3 2 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "12"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr scan1.scn > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "60.0826"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n set scanner to HR+ \n\n"

rm -f stdout.txt image2.i mhdr.txt
$PROGRAM -d2 -scanner=HR+ image2.bin image2.v 2 5 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr image2.v > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "58.3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n the same but with sinogram \n\n"

rm -f stdout.txt scan1.s mhdr.txt
$PROGRAM -d2 -scanner=HR+ scan1.bin scan1.s 3 2 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr scan1.s > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "58.3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n set scanner to HRRT \n\n"

rm -f stdout.txt image2.v mhdr.txt
$PROGRAM -d2 -scanner=HRRT image2.bin image2.v 2 5 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "4"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr image2.v > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "31.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n the same but with sinogram \n\n"

rm -f stdout.txt scan1.s mhdr.txt
$PROGRAM -d2 -scanner=HRRT scan1.bin scan1.s 3 2 29 40 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt scanner_type "4"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

lmhdr scan1.s > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt transaxial_fov "31.2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "---------------------------------------------------------------------\n"

printf "\n 1.2.0 option -zoom \n\n"

printf "\n without option \n\n"

rm -f stdout.txt
$PROGRAM -d2 image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zoom "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n invalid zoom \n\n"

rm -f stdout.txt
$PROGRAM -d2 -zoom=Zoom image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt  Error "invalid option '-zoom=Zoom'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -zoom=-2 image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt  Error "invalid option '-zoom=-2'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM -d2 -zoom=0 image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt  Error "invalid option '-zoom=0'"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n zoom ok with image \n\n"
rm -f stdout.txt image2.v lshdr.txt
$PROGRAM -d2 -zoom=1.5 image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt zoom "1.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lshdr image2.v > lshdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval lshdr.txt recon_zoom "1.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "---------------------------------------------------------------------\n"

printf "\n 1.3.0 option -zero \n\n"

printf "\n without option \n\n"

rm -f stdout.txt image3.v
$PROGRAM -d2 image3.bin image3.v 1 1 80 80 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt fov_corr "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n option fails with sinogram \n\n"

rm -f stdout.txt scan1.s
$PROGRAM -d2 -zero scan1.bin scan1.s 3 2 29 40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "option -zero is available only for images."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n option works with image \n\n"

rm -f stdout.txt image3z.v
$PROGRAM -d2 -zero -scanner=HR+ image3.bin image3z.v 1 1 80 80 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb image3z.v image3z.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch image3.v image3z.v
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch correct_image3z.v image3z.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "---------------------------------------------------------------------\n"

printf "\n 1.4.0 option -mif \n\n"

printf "\n without option ok if given as arguments \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 image2.bin image2.v 2 5 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt planeNr "2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt frameNr "5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt dimx "5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt dimy "5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n fails without option and arguments \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 image2.bin image2.v  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing/invalid data size argument."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n fails if both option and arguments \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=image2.inf image2.bin image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n fails if file does not exist \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=nonexisting.fil image2.bin image2.v  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid matrix information file."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n fails if file has stupid contents \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=image2.bin image2.bin image2.v  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid matrix information file."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "---------------------------------------------------------------------\n"

printf "\n 1.5.0 transpose option \n\n"

printf "\n without option \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=image2.inf image2.bin image2.v  &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt transpose "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb image2.v image2.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n with option \n\n"

rm -f stdout.txt image2_transposed.v
$PROGRAM -d2 -transpose -mif=image2.inf image2.bin image2_transposed.v  &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt transpose "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb image2_transposed.v image2_transposed.tif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
imgmatch correct_image2_transposed.v image2_transposed.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "---------------------------------------------------------------------\n"

printf "\n 1.6.0 option to switch byte order \n\n"

printf "\n without option \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=image2.inf image2.bin image2.v  &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt change_endian "0"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n with option \n\n"

rm -f stdout.txt image2e.v temp.bin
convend float image2.bin temp.bin
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -d2 -e -mif=image2.inf temp.bin image2e.v  &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt change_endian "1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch image2.v image2e.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 2.0.0 input file and parameters ok, quantitation ok \n\n"

rm -f flat.bin flat.mif temp.v frame.sif
img2flat original.v flat.bin flat.mif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -mif=flat.mif flat.bin temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 temp.v original.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 input file not given \n\n"

rm -f stdout.txt image2.v
$PROGRAM -mif=image2.inf image2.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt image2.v
$PROGRAM image2.v 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing/invalid data size argument."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.1.1 input file does not exist \n\n"

rm -f stdout.txt image2.v
$PROGRAM -mif=image2.inf nonexisting.bin image2.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "cannot open file nonexisting.bin"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n===================================================================\n"

printf "\n 3.0.0 fail if output filename not given \n\n"

rm -f image2.v stdout.txt
$PROGRAM -mif=image2.inf image2.bin &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f image2.v stdout.txt
$PROGRAM image2.bin 5 2 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "missing/invalid data size argument."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 3.0.1 fail if output filename is the same as input filename \n\n"

rm -f temp.v stdout.txt
cp -f image1.bin temp.v
$PROGRAM temp.v temp.v 1 1 40 40 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "same name for input and output file."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.1.0 existing output file is overwritten \n\n"

rm -f image1.v image2.v
$PROGRAM -transpose image1.bin image1.v 1 1 40 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -mif=image2.inf image2.bin image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -transpose image1.bin image2.v 1 1 40 40
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch image1.v image2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 3.2.0 Output extension is identified correctly \n\n"

prinf "\n ECAT 7 image volume \n\n"

rm -f stdout.txt
$PROGRAM -d2 -mif=image1.inf image1.bin image1.v &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "type" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt _fileFormat 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

prinf "\n ECAT 6 image \n\n"

rm -f stdout.txt
$PROGRAM -d2 -mif=image1.inf image1.bin image1.img &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "type" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt _fileFormat 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

prinf "\n ECAT 7 sinogram \n\n"

rm -f stdout.txt
$PROGRAM -d2 -mif=scan1.inf scan1.bin scan1.s &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "type" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt _fileFormat 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

prinf "\n ECAT 6 sinogram \n\n"

rm -f stdout.txt
$PROGRAM -d2 -mif=scan1.inf scan1.bin scan1.scn &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "type" 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt _fileFormat 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


prinf "\n NIfTI 1S image \n\n"

rm -f stdout.txt output.nii
$PROGRAM -d2 -mif=image1.inf image1.bin output.nii &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "type" 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt _fileFormat 32
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n 4.0.0 Matrix data dimensions: both MIF file and on command-line \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 -mif=image2.inf image2.bin image2.v 1 10 5 5 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "too many arguments."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.1.0 Matrix data dimensions: binary file too small \n\n"

rm -f stdout.txt image2.v
$PROGRAM -d2 image2.bin image2.v 2 5 128 128 &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "file does not contain all pixel values."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 4.1.1 Matrix data dimensions: binary file too big \n\n"

rm -f stdout.txt image2.v mhdr.txt
$PROGRAM -d2 image2.bin image2.v 2 4 5 5 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning "some data in image2.bin were not read!"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
lmhdr image2.v > mhdr.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt num_planes "2"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval mhdr.txt num_frames "4"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"

printf "\n Planes and frames \n"

printf "\n 5.0.0 More than one plane and frame in ECAT 7 \n\n"

rm -f frame.sif temp.v temp.mif temp.bin
img2flat original.v temp.bin temp.mif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -mif=temp.mif temp.bin temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.v frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.v temp.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 5.0.1 More than one plane and frame in ECAT 6 \n\n"

rm -f frame.sif temp.img temp.mif temp.bin
img2flat original.img temp.bin temp.mif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -mif=temp.mif temp.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe original.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 original.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.1.0 Only one image plane \n\n"

rm -f frame.sif temp.img temp.mif temp.bin oneplane.img
esplit original.img 1-3 2 oneplane.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2flat oneplane.img temp.bin temp.mif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -mif=temp.mif temp.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe oneplane.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -planes=n -abs=0.1 -rel=0.5 oneplane.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 5.2.0 Only one image frame \n\n"

rm -f frame.sif temp.img temp.mif temp.bin oneframe.img
esplit original.img 2 1-2 oneframe.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2flat oneframe.img temp.bin temp.mif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -mif=temp.mif temp.bin temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe oneframe.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe temp.img frame.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.5 oneframe.img temp.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

