#!/bin/bash
#: Title      : test_imgadd
#: Date       : 2016-11-18
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgadd$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

#if [ ! -f calibrationstudyF18-fore-128.i.hdr ]; then
#  printf "Failed: required data does not exist.\n"
#  exit 1
#fi


printf "\n making test data \n"


if [ ! -f temp1.sif ]; then
  printf "18/11/2016 18:12:09 1 4 1 Test F-18\n" > temp1.sif
  printf "0 7200 0 0\n" >> temp1.sif
fi
if [ ! -f temp6.sif ]; then
  printf "18/11/2016 18:12:09 6 4 1 Test O-15\n" > temp6.sif
  printf "  0  10 0 0\n" >> temp6.sif
  printf " 10  20 0 0\n" >> temp6.sif
  printf " 20  60 0 0\n" >> temp6.sif
  printf " 60 120 0 0\n" >> temp6.sif
  printf "120 240 0 0\n" >> temp6.sif
  printf "240 480 0 0\n" >> temp6.sif
fi

if [ ! -f petmask.v ]; then
  simcirc -format=float 128 100 temp.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=hrrt -zoom=1.0 temp.bin petmask.v 1 1 128 128 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f pixels1.pxl ]; then
  printf "64,64,1  \n"  > pixels1.pxl
  printf "64,64,18 \n" >> pixels1.pxl
  printf "64,64,19 \n" >> pixels1.pxl
  printf "64,64,189\n" >> pixels1.pxl
  printf "64,64,190\n" >> pixels1.pxl
  printf "64,64,207\n" >> pixels1.pxl
fi
if [ ! -f pixels6.pxl ]; then
  printf "1,1,1     \n"  > pixels6.pxl
  printf "64,64,17  \n" >> pixels6.pxl
  printf "128,128,35\n" >> pixels6.pxl
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Simulate HRRT calibration image. \n"
printf " Test case 2: ECAT 7 format. \n"
printf " Test case 3: Using and not using option -x. \n"
printf " Expected result: Correct result image is written. \n\n"

rm -f output.v output.ift output.tac output.dat

imgcalc petmask.v x 0.25 out.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 5.0 in.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -x=18 temp1.v out.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM -x=171 temp2.v in.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output.v temp1.v temp2.v temp1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
rm -f temp1.v temp2.v

eframe output.v temp1.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift num_planes 207
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift num_frames 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

pxl2tac output.v output.tac pixels1.pxl 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.dat value[1][1] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][1] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[3][1] 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[4][1] 5
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[5][1] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[6][1] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n 1.1.0 \n"
printf " Test case 1: Simulate dynamic image. \n"
printf " Test case 2: ECAT 7 format. \n"
printf " Expected result: Correct result image is written. \n\n"

rm -f output.v output.ift output.tac output.dat

imgcalc petmask.v x 0.25 frame1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 200.0 frame2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 140.0 frame3.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 100.0 frame4.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 80.0 frame5.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
imgcalc petmask.v x 70.0 frame6.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
ecatcat frame1.v frame2.v frame3.v frame4.v frame5.v frame6.v plane1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
eframe plane1.v temp6.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

$PROGRAM -x=35 output.v plane1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

lmhdr output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s output.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift num_planes 35
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.ift num_frames 6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

pxl2tac output.v output.tac pixels6.pxl 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.0001 output.dat value[1][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[1][6] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[3][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[3][6] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][1] 0.25
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][2] 200
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][3] 140
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][4] 100
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][5] 80
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
iftisval -abs=0.0001 output.dat value[2][6] 70
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"





printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

