#!/bin/bash
#: Title      : test_imgbox
#: Date       : 2016-06-14
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgbox$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f mat1.dat ] || [ ! -f mat1.bin ] || [ ! -f mat1.v ]; then
  rm -f mat1.bin mat1.v
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mat1.dat
  printf "0 1 1 1 1 1 0 0 2 2 2 2 2 2 2 0\n" >> mat1.dat
  printf "0 1 1 1 1 1 0 0 2 2 2 2 2 2 2 0\n" >> mat1.dat
  printf "0 1 1 1 1 1 0 0 2 2 2 2 2 2 2 0\n" >> mat1.dat
  printf "0 1 1 1 1 1 0 0 2 2 2 2 2 2 2 0\n" >> mat1.dat
  printf "0 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 4 4 4 4 4 4 4 4\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 0 0 0 0 0 0 0 0\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 0 0 0 0 0 5 0 0\n" >> mat1.dat
  printf "0 0 3 3 3 0 0 0 0 0 0 0 0 5 0 0\n" >> mat1.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0\n" >> mat1.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0\n" >> mat1.dat

  asc2flat mat1.dat mat1.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mat1.bin mat1.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f mat2.dat ] || [ ! -f mat2.bin ] || [ ! -f mat2.v ]; then
  rm -f mat2.bin mat2.v
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n"  > mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat
  printf "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0\n" >> mat2.dat

  asc2flat mat2.dat mat2.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -scanner=HRRT mat2.bin mat2.v 1 1 16 16
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f image3d.v ]; then
  imgcalc mat1.v x 2 mat3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd image3d.v mat2.v mat1.v mat3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f 1.vrd ]; then
  printf "corner1 := 2 2 2\n"  > 1.vrd
  printf "corner2 := 6 6 2\n" >> 1.vrd
fi
if [ ! -f 2.vrd ]; then
  printf "corner1 := 9 2 2\n"   > 2.vrd
  printf "corner2 := 15 5 2\n" >> 2.vrd
fi
if [ ! -f 3.vrd ]; then
  printf "corner1 := 3 9 2\n"   > 3.vrd
  printf "corner2 := 5 14 2\n" >> 3.vrd
fi
if [ ! -f 4.vrd ]; then
  printf "corner1 := 9 9 2\n"   > 4.vrd
  printf "corner2 := 16 9 2\n" >> 4.vrd
fi
if [ ! -f 5.vrd ]; then
  printf "corner1 := 14 13 2\n"  > 5.vrd
  printf "corner2 := 14 16 2\n" >> 5.vrd
fi

if [ ! -f image4d.v ]; then
  printf "\n making 4D image for testing \n"
  printf "start[minutes]	end[Bq/cc]	reg1	reg2	reg3	reg4\n" > 4d.tac
  printf "0	60	0	-100	0	10\n" >> 4d.tac
  printf "60	120	1000	0	1000	40\n" >> 4d.tac
  printf "120	240	0	100	500	50\n" >> 4d.tac
  printf "240	360	0	200	400	50\n" >> 4d.tac
  printf "360	480	0	300	300	40\n" >> 4d.tac
  printf "480	600	0	400	200	30\n" >> 4d.tac
  printf "600	1200	0	500	100	25\n" >> 4d.tac
  printf "1200	1800	0	600	10	20\n" >> 4d.tac
  rm -f 4d.sif
  tacframe 4d.tac 4d.sif
  dft2img -scanner=HR+ -zoom=1.5 -dim=8 4d.tac image4d.v image4d.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f 4d.vrd ]; then
  printf "corner1 := 2 2 1\n"  > 4d.vrd
  printf "corner2 := 3 3 1\n" >> 4d.vrd
fi

if [ ! -f ana/image4d.img ] || [ ! -f ana/image4d.hdr ]; then
  rm -f ana/*
  ecat2ana -sif -o=ana image4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nii/image4d.nii ] || [ ! -f nii/image4d.sif ]; then
  rm -f nii/*
  ecat2nii -sif -o=nii image4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case: Extract 1.vrd. \n"
printf " Expected result: Correct range extracted. \n\n"

rm -f output1.v
$PROGRAM image3d.v 1.vrd output1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft image3d.v 1.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM output1.v > output1.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output1.ift image_dimensions "5 5 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min output1.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case: Extract 2.vrd. \n"
printf " Expected result: Correct range extracted. \n\n"

rm -f output2.v
$PROGRAM image3d.v 2.vrd output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft image3d.v 2.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM output2.v > output2.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output2.ift image_dimensions "7 4 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min output2.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case: Extract 3.vrd. \n"
printf " Expected result: Correct range extracted. \n\n"

rm -f output3.v
$PROGRAM image3d.v 3.vrd output3.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft image3d.v 3.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM output3.v > output3.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output3.ift image_dimensions "3 6 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min output3.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case: Extract 4.vrd. \n"
printf " Expected result: Correct range extracted. \n\n"

rm -f output4.v
$PROGRAM image3d.v 4.vrd output4.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft image3d.v 4.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM output4.v > output4.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output4.ift image_dimensions "8 1 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min output4.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.4 \n"
printf " Test case: Extract 5.vrd. \n"
printf " Expected result: Correct range extracted. \n\n"

rm -f output5.v
$PROGRAM image3d.v 5.vrd output5.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft image3d.v 5.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
$PROGRAM output5.v > output5.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output5.ift image_dimensions "1 4 1"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min output5.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"

printf "\n 1.1.0 \n"
printf " Test case 1: Dynamic ECAT image. \n"
printf " Test case 2: Cropping. \n"
printf " Expected result: Frame times are preserved. \n\n"

rm -f output.v output.sif
$PROGRAM image4d.v 4d.vrd output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe output.v output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n -abs=0.1 -rel=0.1 4d.sif output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Dynamic ECAT image. \n"
printf " Test case 2: Setting zeroes. \n"
printf " Expected result: Frame times are preserved. \n\n"

rm -f output.v output.sif
$PROGRAM -zero image4d.v 4d.vrd output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
eframe output.v output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=n -abs=0.1 -rel=0.1 4d.sif output.sif
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.2 \n"
printf " Test case 1: Dynamic NIfTI image. \n"
printf " Test case 2: Setting zeroes. \n"
printf " Expected result: No errors, but SIF not written. \n\n"

rm -f nii/output.*
$PROGRAM nii/image4d 4d.vrd nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n 1.1.3 \n"
printf " Test case 1: Dynamic Analyze image. \n"
printf " Test case 2: Cropping. \n"
printf " Notice: Writing Analyze is not supported, thus written in NIfTI. \n"
printf " Expected result: No errors, but SIF not written. \n\n"

rm -f ana/output.*
$PROGRAM ana/image4d 4d.vrd ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"


printf "\n-------------------------------------------------------------------\n"



printf "\n 2.0.0 \n"
printf " Test case: Option -zero with 1.vrd. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output21.v
img2dft image3d.v 1.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -zero image3d.v 1.vrd output21.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output21.v > output21.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output21.ift image_dimensions "16 16 3"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min -thr=1,A output21.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Option -zero with 2.vrd. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output22.v
img2dft image3d.v 2.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -zero image3d.v 2.vrd output22.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min -thr=1,A output22.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Option -zero with 3.vrd. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output23.v
img2dft image3d.v 3.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -zero image3d.v 3.vrd output23.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min -thr=1,A output23.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.3 \n"
printf " Test case: Option -zero with 4.vrd. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output24.v
img2dft image3d.v 4.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -zero image3d.v 4.vrd output24.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min -thr=1,A output24.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.4 \n"
printf " Test case: Option -zero with 5.vrd. \n"
printf " Expected result: Correct output image. \n\n"

rm -f output25.v
img2dft image3d.v 5.vrd correct.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

$PROGRAM -zero image3d.v 5.vrd output25.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imghead -min -thr=1,A output25.v output.tac 
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.01 -rel=0.1 correct.tac output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


