#!/bin/bash
#: Title      : test_imgdelpl
#: Date       : 2018-06-03
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgdelpl$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f original.tac ]; then
  rm -f original.v volume.v
  printf "start[seconds]	end[Bq/cc]	reg1	reg2	reg3	reg4\n" > original.tac
  printf "0	60	0	-100	-10	10\n" >> original.tac
  printf "60	120	1000	0	-10	40\n" >> original.tac
  printf "120	240	0	100	0	50\n" >> original.tac
  printf "240	360	0	200	0	50\n" >> original.tac
  printf "360	480	0	300	0	40\n" >> original.tac
  printf "480	600	0	400	0	30\n" >> original.tac
  printf "600	1200	0	500	0	25\n" >> original.tac
  printf "1200	1800	0	600	0	20\n" >> original.tac
fi


printf "\n making test data \n"

if [ ! -f original.v ] || [ ! -f volume.v ]; then
  rm -f correct*.v *.img ana/* nii/*
  dft2img -scanner=HR+ -zoom=2 -dim=16 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc original.v x 2 original2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc original.v x 4 original4.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd volume.v original.v original2.v original4.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f volume.img ]; then
  e7to63 -c=o volume.v volume.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f ana/volume.img ] || [ ! -f ana/volume.hdr ]; then
  rm -f ana/*
  ecat2ana -sif -o=ana volume.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f nii/volume.nii ] || [ ! -f nii/volume.sif ]; then
  rm -f nii/*
  ecat2nii -sif -o=nii volume.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f correct2-3.v ]; then
  imgadd correct2-3.v original2.v original4.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f correct13.v ]; then
  imgadd correct13.v original.v original4.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f correct1-2.v ]; then
  imgadd correct1-2.v original.v original2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct2z.v ] || [ ! -f zero.v ]; then
  imgcalc original.v x 0 zero.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd correct2z.v original.v zero.v original4.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct13z.v ]; then
  imgadd correct13z.v zero.v original2.v zero.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Delete plane nr 1. \n"
printf " Test case 2: Dynamic image volume in ECAT 7 format. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 1 1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct2-3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: Delete plane nr 1. \n"
printf " Test case 2: Dynamic image volume in ECAT 6 format. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.img output.v

$PROGRAM volume.img 1 1 output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.01 -rel=0.2 correct2-3.v output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: Delete plane nr 1. \n"
printf " Test case 2: Dynamic image volume in Analyze format. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f ana/output.*

$PROGRAM ana/volume 1 1 ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.02 -rel=0.2 correct2-3.v ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: Delete plane nr 1. \n"
printf " Test case 2: Dynamic image volume in NIfTI format. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f nii/output.*

$PROGRAM nii/volume 1 1 nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.02 -rel=0.2 correct2-3.v nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Delete plane in the middle. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 2 2 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct13.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case: Delete the last plane. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 3 3 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct1-2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Delete all but the first plane. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 2 3 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.0 \n"
printf " Test case: Try to delete non-existing plane. \n"
printf " Expected result: Error. \n\n"

rm -f output.v stdout.txt

$PROGRAM volume.v 4 4 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid plane range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.1 \n"
printf " Test case: Try to delete all planes. \n"
printf " Expected result: Error. \n\n"

rm -f output.v stdout.txt

$PROGRAM volume.v 1 3 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "all planes would be cropped."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.5.0 \n"
printf " Test case: Set to zeroes the plane in the middle. \n"
printf " Expected result: Output image contain correct pixel values. \n\n"

rm -f output.v

$PROGRAM -zero volume.v 2 2 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct2z.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.5.1 \n"
printf " Test case: Output image name not given. \n"
printf " Expected result: Input image is overwritten. \n\n"

rm -f output.v
cp -f volume.v output.v

$PROGRAM -zero output.v 2 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct2z.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n-------------------------------------------------------\n"

printf "\n 2.0.0 \n"
printf " Test case: Delete one plane from beginning. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM -d4 volume.v -1 0 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct2-3.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.1 \n"
printf " Test case: Delete the last plane. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 0 -1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct1-2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.2 \n"
printf " Test case: Delete two last planes. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v 0 -2 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 original.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.0.3 \n"
printf " Test case: Delete one plane from both ends. \n"
printf " Expected result: Output image contain correct planes. \n\n"

rm -f output.v

$PROGRAM volume.v -1 -1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 original2.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: Try to delete too many planes. \n"
printf " Expected result: Error. \n\n"

rm -f output.v stdout.txt

$PROGRAM volume.v -2 -1 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "all planes would be cropped."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.1 \n"
printf " Test case: Enter zeroes as plane numbers. \n"
printf " Expected result: Error. \n\n"

rm -f output.v stdout.txt

$PROGRAM volume.v 0 0 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid plane range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.2 \n"
printf " Test case: Enter positive and negative number. \n"
printf " Expected result: Error. \n\n"

rm -f output.v stdout.txt

$PROGRAM volume.v -1 1 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid plane range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM volume.v 1 -1 output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid plane range."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.2.0 \n"
printf " Test case: Set to zeroes the planes in both ends. \n"
printf " Expected result: Output image contain correct pixel values. \n\n"

rm -f output.v

$PROGRAM -zero volume.v -1 -1 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.001 correct13z.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

