#!/bin/bash
#: Title      : test_imgfiltl
#: Date       : 2022-02-10
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgfiltl$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n verifying that required data exists \n"

if [ ! -f vol.dat ] || [ ! -f correct_vol5-3.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f flat.v ] || [ ! -f correct_flat5.v ]; then
  printf "0	0	0	0	0	0	0	0	0	0	0	0\n" > flat.dat
  printf "0	0	0	0	0	0	0	0	0	0	0	0\n" >> flat.dat
  printf "0	0	1	1	2	2	1	2	2	0	0	0\n" >> flat.dat
  printf "0	0	2	1	3	2	1	1	4	1	0	0\n" >> flat.dat
  printf "0	1	0	2	2	4	3	4	2	2	1	0\n" >> flat.dat
  printf "0	0	2	2	2	3	5	3	3	3	2	0\n" >> flat.dat
  printf "0	1	1	3	4	4	4	4	2	3	1	0\n" >> flat.dat
  printf "0	1	2	2	5	2	3	4	3	2	0	0\n" >> flat.dat
  printf "0	0	1	3	2	4	2	5	3	1	1	0\n" >> flat.dat
  printf "0	1	1	1	2	3	3	2	1	1	1	0\n" >> flat.dat
  printf "0	0	0	0	0	0	0	0	0	0	0	0\n" >> flat.dat
  printf "0	0	0	0	0	0	0	0	0	0	0	0\n" >> flat.dat

  printf "0.111	0.167	0.267	0.400	0.467	0.533	0.600	0.467	0.333	0.267	0.167	0.000\n" > correct_flat5.dat
  printf "0.250	0.313	0.500	0.700	0.800	0.800	1.000	0.800	0.600	0.500	0.438	0.083\n" >> correct_flat5.dat
  printf "0.267	0.400	0.600	0.920	1.080	1.240	1.400	1.240	0.960	0.760	0.600	0.267\n" >> correct_flat5.dat
  printf "0.400	0.600	0.840	1.280	1.640	1.840	2.040	1.920	1.600	1.200	1.000	0.600\n" >> correct_flat5.dat
  printf "0.533	0.850	1.200	1.800	2.280	2.600	2.760	2.600	2.160	1.600	1.300	0.867\n" >> correct_flat5.dat
  printf "0.667	1.000	1.440	2.040	2.560	2.920	3.080	2.880	2.440	1.800	1.450	1.000\n" >> correct_flat5.dat
  printf "0.600	1.050	1.440	2.120	2.680	3.240	3.280	3.120	2.640	1.960	1.450	1.067\n" >> correct_flat5.dat
  printf "0.667	1.050	1.440	2.080	2.640	3.080	3.120	2.920	2.480	1.800	1.350	1.000\n" >> correct_flat5.dat
  printf "0.533	0.850	1.200	1.720	2.080	2.480	2.480	2.240	1.840	1.360	0.950	0.667\n" >> correct_flat5.dat
  printf "0.400	0.600	0.840	1.200	1.440	1.720	1.760	1.560	1.280	0.960	0.650	0.400\n" >> correct_flat5.dat
  printf "0.250	0.438	0.550	0.900	1.100	1.350	1.350	1.250	1.000	0.750	0.500	0.333\n" >> correct_flat5.dat
  printf "0.222	0.250	0.333	0.533	0.667	0.733	0.733	0.667	0.533	0.333	0.250	0.222\n" >> correct_flat5.dat

  asc2flat flat.dat flat.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -zoom=2.5 -scanner=HR+ flat.bin flat.v 1 1 12 12 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s flat.v flat.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat correct_flat5.dat correct_flat5.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -zoom=2.5 -scanner=HR+ correct_flat5.bin correct_flat5.v 1 1 12 12 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s correct_flat5.v correct_flat5.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


if [ ! -f vol.v ] || [ ! -f correct_vol5-3.v ]; then
  rm -f dyn.v correct_dyn5-3.v

  asc2flat vol.dat vol.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -zoom=2.5 -scanner=HR+ vol.bin vol.v 6 1 12 22
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s vol.v vol.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  asc2flat correct_vol5-3.dat correct_vol5-3.bin
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  flat2img -zoom=2.5 -scanner=HR+ correct_vol5-3.bin correct_vol5-3.v 6 1 12 22
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s correct_vol5-3.v correct_vol5-3.tif
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

fi


if [ ! -f dyn.v ] || [ ! -f correct_dyn5-3.v ]; then
  rm -f correct_subtr.v

  imgcalc vol.v x 2 dynf2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc vol.v x 3 dynf3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcat dyn.v vol.v dynf2.v dynf3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  imgcalc correct_vol5-3.v x 2 correct_dyn5-3f2.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc correct_vol5-3.v x 3 correct_dyn5-3f3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcat correct_dyn5-3.v correct_vol5-3.v correct_dyn5-3f2.v correct_dyn5-3f3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f correct_subtr.v ]; then
  imgcalc dyn.v - correct_dyn5-3.v correct_subtr.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcutof correct_subtr.v 0 9999
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Flat x,y image filtering over 5 pixels. \n"
printf " Expected result: Correctly filtered image. \n\n"

rm -f filtered.v stdout.txt

$PROGRAM flat.v filtered.v 5 0 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f filtered.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.002 correct_flat5.v filtered.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: 3D image filtering over 5 pixels in xy dimension and 3 pixels in z. \n"
printf " Expected result: Correctly filtered image. \n\n"

rm -f filtered.v stdout.txt

$PROGRAM vol.v filtered.v 5 3 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f filtered.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.002 correct_vol5-3.v filtered.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.1 \n"
printf " Test case: 4D image filtering over 5 pixels in xy dimension and 3 pixels in z. \n"
printf " Expected result: Correctly filtered image. \n\n"

rm -f filtered.v stdout.txt

$PROGRAM dyn.v filtered.v 5 3 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f filtered.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.002 correct_dyn5-3.v filtered.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Options -nonegatives and -difference. \n"
printf " Expected result: Correct output image. \n\n"

rm -f subtracted.v stdout.txt

$PROGRAM -nonegatives -difference dyn.v subtracted.v 5 3 &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
if [ ! -f subtracted.v ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

imgmatch -abs=0.003 correct_subtr.v subtracted.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


