#!/bin/bash
#: Title      : test_imgftac
#: Date       : 2018-02-16
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgftac$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi


if [ ! -f original.tac ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "\n making test data \n"

if [ ! -f original.v ] || [ ! -f original.img ]; then
  rm -f ana/* nii/*
  dft2img -scanner=HR+ -zoom=2 -dim=4 original.tac original.v original.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 -c=o original.v original.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f ana/original.img ] || [ ! -f ana/original.hdr ]; then
  rm -f ana/*
  ecat2ana -sif -o=ana original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f nii/original.nii ] || [ ! -f nii/original.sif ]; then
  rm -f nii/*
  ecat2nii -sif -o=nii original.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f original_1.tac ] || [ ! -f original_2.tac ]; then
  tacsplit --force -name=filename_nr original.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f x2p3.v ]; then
  rm -f x2p3.tac x2p3_1.tac x2p3_2.tac
  imgcalc original.v x 2 temp.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc temp.v + 3 x2p3.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f temp.v
  printf "\n ok \n"
fi

if [ ! -f x2p3.tac ] || [ ! -f x2p3_1.tac ] || [ ! -f x2p3_2.tac ]; then
  img2dft x2p3.v original.roi x2p3.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacsplit --force -name=filename_nr x2p3.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: ECAT7 image. \n"
printf " Test case 2: TAC from 1st ROI. \n"
printf " Expected result: Output image contain correct cc values. \n\n"

rm -f output.v output.tac output.ift

$PROGRAM original.v original_1.tac output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift value[1][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.1 \n"
printf " Test case 1: ECAT6 image. \n"
printf " Test case 2: TAC from 2nd ROI. \n"
printf " Expected result: Output image contain correct cc values. \n\n"

rm -f output.img output.tac output.ift

$PROGRAM original.img original_2.tac output.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.img original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift value[2][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.2 \n"
printf " Test case 1: NIfTI image. \n"
printf " Test case 2: TAC from 4th ROI. \n"
printf " Expected result: Output image contain correct cc values. \n\n"

rm -f nii/output.* output.tac output.ift

$PROGRAM nii/original original_4.tac nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nii/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift value[4][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.0.3 \n"
printf " Test case 1: Analyze image. \n"
printf " Test case 2: TAC from 4th ROI. \n"
printf " Expected result: Output image contain correct cc values. \n\n"

rm -f ana/output.* output.tac output.ift

$PROGRAM ana/original original_4.tac ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output original.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift output.tac > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.001 output.ift value[4][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n-------------------------------------------------------------------\n"


printf "\n 1.1.0 \n"
printf " Test case 1: Optional slope and intercept images. \n"
printf " Test case 2: For ROI 1 cc=1, slope=2, and ic=3. \n"
printf " Expected result: Output images contain correct values. \n\n"

rm -f cc.v cc.tac cc.ift
rm -f slope.v slope.tac slope.ift
rm -f ic.v ic.tac ic.ift

$PROGRAM -slope=slope.v -ic=ic.v x2p3.v original_1.tac cc.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft cc.v original.roi cc.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift cc.tac > cc.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft slope.v original.roi slope.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift slope.tac > slope.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ic.v original.roi ic.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift ic.tac > ic.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.005 cc.ift value[1][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 slope.ift value[1][1] 2
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 ic.ift value[1][1] 3
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: Optional slope and intercept images. \n"
printf " Test case 2: Optional integral curve used. \n"
printf " Expected result: Output images contain correct values. \n\n"

rm -f cc.v cc.tac cc.ift
rm -f slope.v slope.tac slope.ift
rm -f ic.v ic.tac ic.ift

$PROGRAM -integral -slope=slope.v -ic=ic.v x2p3.v x2p3_1.tac cc.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft cc.v original.roi cc.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift cc.tac > cc.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft slope.v original.roi slope.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift slope.tac > slope.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft ic.v original.roi ic.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
taclist -ift ic.tac > ic.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

iftisval -abs=0.005 cc.ift value[1][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 slope.ift value[1][1] 1
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval -abs=0.005 ic.ift value[1][1] 0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.v
$PROGRAM -stupidoption original.v original_1.tac output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM original.v original_2.tac output.v extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM original_2.tac output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM original.v  output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM original.v original_1.tac   &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "missing command-line argument; use option --help"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.v original_1.tac output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt
$PROGRAM original.v nonexistingfile.tac output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

