#!/bin/bash
#: Title      : test_imginv
#: Date       : 2018-05-31
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imginv$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


# printf "\n verifying that required data exists \n"


printf "\n making test data \n"

if [ ! -f data1.tac ] || [ ! -f data1.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2\n" > data1.tac
  printf "0.0	2.0	0.100	0.200\n" >> data1.tac
  printf "2.0	4.0	0.010	0.020\n" >> data1.tac
  printf "4.0	8.0	0.020	0.025\n" >> data1.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 data1.tac data1.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f data2.tac ] || [ ! -f data2.v ]; then
  rm -f data2.v
  printf "start[minutes]	end[kBq/cc]	roi1	roi2\n" > data2.tac
  printf "0.0	2.0	0.100	-0.20\n"   >> data2.tac
  printf "2.0	4.0	0.0	0.020\n"   >> data2.tac
  printf "4.0	8.0	0.020	1.0E-20\n" >> data2.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 data2.tac data2.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f inv1.tac ] || [ ! -f inv1.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2\n" > inv1.tac
  printf "0.0	2.0	10.0	5.0\n"  >> inv1.tac
  printf "2.0	4.0	100.0	50.0\n" >> inv1.tac
  printf "4.0	8.0	50.0	40.0\n" >> inv1.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 inv1.tac inv1.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f inv2.tac ] || [ ! -f inv2.v ]; then
  printf "start[minutes]	end[kBq/cc]	roi1	roi2\n" > inv2.tac
  printf "0.0	2.0	10.0	0.0\n"   >> inv2.tac
  printf "2.0	4.0	0.0	50.0\n"  >> inv2.tac
  printf "4.0	8.0	50.0	0.0\n"   >> inv2.tac

  dft2img -zoom=2 -scanner=HRRT -dim=8 inv2.tac inv2.v data.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Image where all pixel values can be inverted. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v

$PROGRAM data1.v output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -abs=0.1 -rel=0.1 inv1.v output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.1.0 \n"
printf " Test case: Image contains pixel values that cannot be inverted. \n"
printf " Expected result: Correct image saved. \n\n"

rm -f output.v

$PROGRAM data2.v output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output.v data.roi output.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

cat output.tac

imgmatch -abs=0.1 -rel=0.1 inv2.v output.v
if [ $? -ne 0 ] ; then printf "\nFailed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0


