#!/bin/bash
#: Title      : test_imgratio
#: Date       : 2019-06-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgratio$EXT;
if [ ! -f $PROGRAM ]; then
  printf "\nError: application file missing.\n\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"

# Check that required files exist
if [ ! -f dftratio.tac ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_1_0_0.dft ] || [ ! -f correct_1_1_0.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi
if [ ! -f correct_1_3_0.dft ]; then
  printf "\nError: required file missing.\n\n"
  exit 1
fi


if [ ! -f dynamic.v ] || [ ! -f dynamic.roi ] || [ ! -f dynamic.img ]; then
  printf "\nCreating test image\n"
  dft2img -scanner=HR+ -zoom=2 -dim=8 dftratio.tac dynamic.v dynamic.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  e7to63 dynamic.v dynamic.img
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f ana\dynamic.*
  rmdir ana
  ecat2ana -sif -o=ana dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

  rm -f nifti\dynamic.*
  rmdir nifti
  ecat2nii -sif -o=nifti dynamic.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f ref.tac ]; then
  printf "\nExtract reference region TTAC\n"
  tacadd -ovr ref.tac dftratio.tac ref
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n 1.0.0 \n"
printf " Test case 1: Reasonable time range 20 to 30 min. \n"
printf " Test case 2: Option -bound. \n"
printf " Test case 3: Image format is ECAT7. \n"
printf " Expected result: Result image is created, and results are close to correct \n\n"

rm -f output_1_0_0.v
$PROGRAM -bound dynamic.v ref.tac 20 30 output_1_0_0.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_1_0_0.v dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.2 -abs=0.01 correct_1_0_0.dft output_1_0_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case 1: End part time range 40 to 60 min. \n"
printf " Test case 2: Without option -bound. \n"
printf " Test case 3: Image format is ECAT6. \n"
printf " Expected result: Result image is created, and results are close to correct \n\n"

rm -f output_1_1_0.img
$PROGRAM dynamic.img ref.tac 40 60 output_1_1_0.img
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft output_1_1_0.img dynamic.roi
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.2 -abs=0.01 correct_1_1_0.dft output_1_1_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.2.0 \n"
printf " Test case 1: End part time range 40 to 60 min. \n"
printf " Test case 2: Without option -bound. \n"
printf " Test case 3: Image format is Analyze. \n"
printf " Expected result: Result image is created, and results are close to correct \n\n"

rm -f ana/output_1_2_0.*
$PROGRAM ana/dynamic ref.tac 40 60 ana/output_1_2_0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft ana/output_1_2_0 dynamic.roi output_1_2_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.2 -abs=0.01 correct_1_1_0.dft output_1_2_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case 1: Whole time range 0 to 60 min. \n"
printf " Test case 2: Without option -bound. \n"
printf " Test case 3: Image format is NIfTI. \n"
printf " Expected result: Result image is created, and results are close to correct \n\n"

rm -f nifti/output_1_3_0.*
$PROGRAM nifti/dynamic ref.tac 0 60 nifti/output_1_3_0
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2dft nifti/output_1_3_0 dynamic.roi output_1_3_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -rel=0.2 -abs=0.01 correct_1_3_0.dft output_1_3_0.dft
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.4.0 \n"
printf " Test case 1: Option to limit max value. \n"
printf " Expected result: Result image max does not exceed given value \n\n"

rm -f output.v output.ift
$PROGRAM -max=6.0 -noneg dynamic.v ref.tac 0 60 output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmax output.v > output.ift
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
cat output.ift
iftisval -abs=0.0001 output.ift max 6
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
