#!/bin/bash
#: Title      : test_imgshrink
#: Date       : 2019-11-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgshrink$EXT;
if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


#printf "\n verifying that required data exists \n"


printf "\n making test data \n"


if [ ! -f imgshrink.tac ]; then
  printf "start[seconds]	end[kBq/cc]	roi1	roi2	roi3	roi4\n" > imgshrink.tac
  printf "0.000000	1.000000	1.0e+00	2.0e+00	3.0e+00	2.0e+00\n" >> imgshrink.tac
  printf "1.000000	2.000000	3.0e+00	6.0e+00	9.0e+00	6.0e+00\n" >> imgshrink.tac
  printf "2.000000	3.000000	6.0e+00	1.2e+01	1.2e+01	1.2e+01\n" >> imgshrink.tac
  printf "3.000000	4.000000	9.0e+00	1.5e+01	1.4e+01	1.1e+01\n" >> imgshrink.tac
  printf "4.000000	5.000000	1.2e+01	1.7e+01	1.5e+01	9.0e+00\n" >> imgshrink.tac
  printf "5.000000	10.00000	1.5e+01	1.6e+01	1.6e+01	6.0e+00\n" >> imgshrink.tac
  printf "10.00000	15.00000	1.7e+01	1.5e+01	1.6e+01	4.0e+00\n" >> imgshrink.tac
  printf "15.00000	20.00000	1.8e+01	1.4e+01	1.6e+01	3.0e+00\n" >> imgshrink.tac
  printf "20.00000	30.00000	1.9e+01	1.3e+01	1.6e+01	2.0e+00\n" >> imgshrink.tac
  printf "30.00000	40.00000	2.0e+01	1.2e+01	1.6e+01	1.5e+00\n" >> imgshrink.tac
  printf "40.00000	60.00000	2.1e+01	1.1e+01	1.6e+01	1.0e+00\n" >> imgshrink.tac
fi


if [ ! -f small2D.v ] || [ ! -f small3D.v ]; then
  rm -f ana/small* nii/small*
  dft2img -scanner=HR+ -zoom=2 -dim=4 imgshrink.tac small2D.v small.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt small2D.v 2017-02-17 08:00:40
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd small3D.v small2D.v small2D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f large2D.v ] || [ ! -f large3D.v ]; then
  rm -f ana/large* nii/large*
  dft2img -scanner=HR+ -zoom=2 -dim=8 imgshrink.tac large2D.v large.roi
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  esetstrt large2D.v 2017-02-17 08:00:40
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd large3D.v large2D.v large2D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  printf "\n ok \n"
fi

if [ ! -f ana/small2D.img ] || [ ! -f ana/small3D.img ]; then
  ecat2ana -sif -o=ana small2D.v small3D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f ana/large2D.img ] || [ ! -f ana/large3D.img ]; then
  ecat2ana -sif -o=ana large2D.v large3D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f nii/small2D.nii ] || [ ! -f nii/small3D.nii ]; then
  ecat2nii -sif -o=nii small2D.v small3D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi
if [ ! -f nii/large2D.nii ] || [ ! -f nii/large3D.nii ]; then
  ecat2nii -sif -o=nii large2D.v large3D.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case 1: Dynamic ECAT7 image. \n"
printf " Test case 2: No options given. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f output.v 

$PROGRAM large3D.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=0.1 -rel=0.1 small2D.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.0.1 \n"
printf " Test case 1: Dynamic ECAT7 image. \n"
printf " Test case 2: Option -z=no \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f output.v

$PROGRAM -z=no large3D.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=y -abs=0.1 -rel=0.1 small3D.v output.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.1.0 \n"
printf " Test case 1: Dynamic NIfTI-1 image. \n"
printf " Test case 2: No options given. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f nii/output.*

$PROGRAM nii/large3D nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=0.1 -rel=0.1 nii/small2D nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Dynamic NIfTI-1 image. \n"
printf " Test case 2: Option -z=no \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f nii/output

$PROGRAM -z=no nii/large3D nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=y -abs=0.1 -rel=0.1 nii/small3D nii/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 1.2.0 \n"
printf " Test case 1: Dynamic Analyze image. \n"
printf " Test case 2: No options given. \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f ana/output.*

$PROGRAM ana/large3D ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=0.1 -rel=0.1 ana/small2D ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.1 \n"
printf " Test case 1: Dynamic Analyze image. \n"
printf " Test case 2: Option -z=no \n"
printf " Expected result: Correct output image contents. \n\n"

rm -f ana/output

$PROGRAM -z=no ana/large3D ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=y -abs=0.1 -rel=0.1 ana/small3D ana/output
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 1.3.0 \n"
printf " Test case: Inflate and deflate using this and imgswell. \n"
printf " Expected result: Correct output images. \n\n"

rm -f output1.v output2.v

imgswell large3D.v output1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
$PROGRAM output1.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
imgmatch -header=n -abs=0.1 -rel=0.1 large3D.v output2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"



printf "\n 2.0.0 \n"
printf " Test case: Invalid option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.v
$PROGRAM -stupidoption large3D.v output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: Extra argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM large3D.v output.v extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.2 \n"
printf " Test case: Missing argument. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM  output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.1.0 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt
$PROGRAM nonexistingfile.v output.v &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

