#!/bin/bash
#: Title      : test_avgfract
#: Date       : 2018-03-08
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../avgfract$EXT;

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f avgfract_correct_mean.rat ] || [ ! -f avgfract_correct_mean2.rat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f avgfract_fract1.rat ] || [ ! -f avgfract_fract2.rat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f avgfract_fract3.rat ] || [ ! -f avgfract_fract4.rat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f avgfract_fract5.rat ] || [ ! -f avgfract_fractone.rat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi


printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Files with two fraction columns. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f avgfract_mean.rat

$PROGRAM avgfract_mean.rat avgfract_fract?.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 avgfract_correct_mean.rat avgfract_mean.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 1.1.0 \n"
printf " Test case: Files with two or one fraction columns. \n"
printf " Expected result: Correct results calculated. \n\n"

rm -f avgfract_mean2.rat

$PROGRAM avgfract_mean2.rat avgfract_fract*.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n ok \n"
tacmatch -abs=0.005 avgfract_correct_mean2.rat avgfract_mean2.rat
if [ $? -ne 0 ] ; then echo Failed! ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n===================================================================\n"
printf "  All passed.\n"
printf "===================================================================\n"
exit 0

