#!/bin/bash
#: Title      : test_disp4dft
#: Date       : 2016-02-01
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../disp4dft$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f plasma.dat ] || [ ! -f plasma_with_dispersion.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f step.dat ] || [ ! -f step_with_dispersion.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi

printf "ok\n"



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 1.0.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM -nonexistingoption ON plasma.dat 5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-nonexistingoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.1.0 \n"
printf " Test case: Too many arguments. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt

$PROGRAM ON plasma.dat 5 output.dat extra &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid argument 'extra'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.0 \n"
printf " Test case: Input filename not given. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM ON 5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 1.3.1 \n"
printf " Test case: Input file does not exist. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM ON nofile.dat 5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error in reading 'nofile.dat'" "cannot open file"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "=====================================================================\n"


printf "\n 2.0.0 \n"
printf " Test case: ON or OFF forgotten. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM  step.dat 2.5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "dispersion must be set ON or OFF."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.0.1 \n"
printf " Test case: ON or OFF spelled wrong. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM oof step.dat 2.5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "dispersion must be set ON or OFF."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.0 \n"
printf " Test case: dispersion ON. \n"
printf " Expected result: reasonably correct tac. \n\n"

rm -f stdout.txt dispersed.dat test1.dat test2.dat

$PROGRAM on plasma.dat 1.0 dispersed.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -i -x=0.7,1,5,15,30,60,120 dispersed.dat test1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=0.7,1,5,15,30,60,120 plasma_with_dispersion.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y -abs=0.01 -rel=1 test1.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.1.1 \n"
printf " Test case: dispersion OFF. \n"
printf " Expected result: reasonably correct tac. \n\n"

rm -f stdout.txt corrected.dat test1.dat test2.dat

$PROGRAM off dispersed.dat 1.0 corrected.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

interpol -i -x=0.7,1,5,15,30,60,120 corrected.dat test1.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
interpol -i -x=0.7,1,5,15,30,60,120 plasma.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi

tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y -abs=0.5 -rel=5 test1.dat test2.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.2.0 \n"
printf " Test case: dispersion time constant forgotten. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

printf "\n 2.2.1 \n"
printf " Test case: dispersion time constant set to zero. \n"
printf " Expected result: Warning, and data is not changed. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step.dat 0 output.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Warning" "dispersion time constant is set to 0."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y step.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.2 \n"
printf " Test case: dispersion time constant set to negative value. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step.dat -5 output.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt "Error" "invalid dispersion time constant."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.3 \n"
printf " Test case: valid dispersion time constant. \n"
printf " Expected result: correctly calculated tac. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step.dat 2.5 output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y step_with_dispersion.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step.dat 2,5 output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch -x=y -y=y -tacnames=y -xunit=y -yunit=y step_with_dispersion.dat output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "=====================================================================\n"


printf "\n 3.0.0 \n"
printf " Test case: output filename forgotten. \n"
printf " Expected result: Error. \n\n"

rm -f stdout.txt output.dat

$PROGRAM on step.dat 2.5  &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 3.1.0 \n"
printf " Test case: option -log. \n"
printf " Expected result: log written in output file. \n\n"

rm -f stdout.txt output.dat

$PROGRAM -log on step.dat 2.5 output.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.dat "dispersion_time" "2.5"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval output.dat "dispersion" "on"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0
