#!/bin/bash
#: Title      : test_imgaafind
#: Date       : 2022-02-20
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../imgaafind$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f radiowater.fit ] || [ ! -f frames.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
printf "ok\n"


# Make BTAC in seconds
if [ ! -f blood.tac ] || [ ! -f radiowater.dat ] ; then
  rm -f tissue.tac dynamic4d.v noisy4d.v
  fit2dat -c=0,600,1 radiowater.fit radiowater.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tactime -nogap radiowater.dat 32.5
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tacstudy -force radiowater.dat sim1
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe -sec radiowater.dat frames.dat blood.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

# Simulate tissue TAC in seconds
if [ ! -f tissue.tac ] || [ ! -f tissue.dat ] ; then
  rm -f dynamic4d.v noisy4d.v
  p2t_3c -nosub radiowater.dat 0.0012 0.0014 0 0 0 0 tissue.dat
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simframe -sec tissue.dat frames.dat tissue.tac 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  tac2svg simulated_tacs.svg -l radiowater.dat -b blood.tac tissue.tac
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

# Simulate dynamic 4D image with changing vessel position and diameter
if [ ! -f dynamic4d.v ] ; then
  rm -f noisy4d.v
  simiart -xpos=-20 -ypos=-20 -diameter=19 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn01.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-17 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn02.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-14 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn03.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-12 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn04.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-10 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn05.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-8 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn06.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-6 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn07.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-4 -diameter=20 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn08.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-2 -diameter=19 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn09.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-1 -diameter=18 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn10.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=-0 -diameter=17 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn11.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=+1 -diameter=16 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn12.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=+2 -diameter=15 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn13.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-20 -ypos=+4 -diameter=14 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn14.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  simiart -xpos=-19 -ypos=+6 -diameter=13 -nopve -dim=128 -pxlsize=4.7 blood.tac tissue.tac dyn15.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgadd dyna.v dyn??.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgfiltg -method=FIR -FWHM dyna.v dynamic4d.v 8 8
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s dynamic4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imginteg -avg dynamic4d.v 0 0 sum.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s sum.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  rm -f dyn??.v
fi

# Simulating noise
if [ ! -f noisy4d.v ] ; then
  fvar4img -i=O-15 -minsd=0.05 dynamic4d.v 0.005 noisy4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s noisy4d.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi

if [ ! -f test.v ] ; then
  imginteg -avg dynamic4d.v 50 5 peakframe.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgfiltl peakframe.v filtxy.v 5 0 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgfiltl peakframe.v filtz.v 0 5 
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgcalc filtz.v - filtxy.v fsubt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s peakframe.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s filtxy.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s filtz.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s fsubt.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgthrs -abs fsubt.v 0 9999
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  imgzavg fsubt.v zavg.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
  img2tif -rb -s zavg.v
  if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
fi


printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"

printf "\n 1.0.0 \n"
printf " Test case: Noiseless image. \n"
printf " Expected result: Peak positions saved in mask image. \n\n"

rm -f mask1.v output1.tac

$PROGRAM -zmask=zmask1.tif -peak=peak1.v dynamic4d.v mask1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s peak1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif mask1.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft dynamic4d.v mask1.v output1.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output1.svg -s blood.tac -l output1.tac -b tissue.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
 


printf "\n 1.0.1 \n"
printf " Test case: Noisy image. \n"
printf " Expected result: Peak positions saved in mask image. \n\n"

rm -f mask2.v output2.tac

$PROGRAM -zmask=zmask2.tif -peak=peak2.v noisy4d.v mask2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif -rb -s peak2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
img2tif mask2.v
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"

img2dft noisy4d.v mask2.v output2.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tac2svg output2.svg -s blood.tac -l output2.tac -b tissue.tac
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"



printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

