#!/bin/bash
#: Title      : test_inpstart
#: Date       : 2014-10-26
#: Author     : "Vesa Oikonen" <vesa.oikonen@utu.fi>
#: Options    : None

# Set the name of executable to test
if [ -n "${OS+1}" ] && [ "$OS" = "Windows_NT" ]; then
EXT=.exe;
else
EXT=;
fi
PROGRAM=../../inpstart$EXT;

printf "=====================================================================\n"
printf "creating test data for %s\n" $PROGRAM
printf "=====================================================================\n"


printf "\n verifying that required data exists \n"

if [ ! -f $PROGRAM ]; then
  printf "Failed: executable does not exist.\n"
  exit 1
fi

if [ ! -f test1.dat ] || [ ! -f test2.dat ]; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test3.dat ] || [ ! -f test4.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test5.dat ] || [ ! -f test11.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test12.dat ] || [ ! -f test21.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test22.dat ] || [ ! -f test31.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f test32.dat ] || [ ! -f test33.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi
if [ ! -f correct_test21.dat ] || [ ! -f correct_test22.dat ] ; then
  printf "Failed: required data does not exist.\n"
  exit 1
fi



printf "\n\n"
printf "=====================================================================\n"
printf "testing %s\n" $PROGRAM
printf "=====================================================================\n"



printf "\n 0.1.0 \n"
printf " Test case: Unknown option. \n"
printf " Expected result: Error. \n"

rm -f stdout.txt
$PROGRAM -stupidoption test1.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error "invalid option '-stupidoption'."
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   General testing \n"
printf "===================================================================\n"

printf "\n 2.0.0 \n"
printf " Test case 1: Files have no problems. \n"
printf " Test case 2: Files with one TAC and several TACs inside. \n"
printf " Expected result: Return code is zero. \n\n"

rm -f stdout.txt

$PROGRAM test1.dat test2.dat test3.dat test4.dat test5.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt Error
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Warning
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"



printf "\n 2.0.1 \n"
printf " Test case 1: File(s) have problems. \n"
printf " Test case 2: Files with one TAC and several TACs inside. \n"
printf " Expected result: Return code is non-zero. \n\n"

rm -f stdout.txt

$PROGRAM test1.dat test2.dat test11.dat test12.dat test5.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
iftisval stdout.txt Error "TAC must be corrected before using as input"
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n 2.1.0 \n"
printf " Test case 1: File(s) have problems that can be fixed. \n"
printf " Test case 2: Option -fix. \n"
printf " Expected result 1: Files are fixed. \n"
printf " Expected result 2: Return code is zero. \n\n"

rm -f stdout.txt
cp -f test21.dat temp21.dat
cp -f test22.dat temp22.dat

$PROGRAM -fix temp21.dat test5.dat temp22.dat &> stdout.txt
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"
tacmatch correct_test21.dat temp21.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch correct_test22.dat temp22.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
iftisval stdout.txt Error
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"


printf "\n 2.2.0 \n"
printf " Test case 1: File(s) have major problems that cannot be fixed. \n"
printf " Test case 2: Option -fix. \n"
printf " Expected result 1: Files are not fixed. \n"
printf " Expected result 2: Return code is non-zero. \n\n"

rm -f stdout.txt
cp -f test31.dat temp31.dat
cp -f test32.dat temp32.dat
cp -f test33.dat temp33.dat

$PROGRAM -fix temp31.dat test5.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch test31.dat temp31.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -fix temp32.dat test5.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch test32.dat temp32.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"

$PROGRAM -fix temp33.dat test5.dat &> stdout.txt
if [ $? -eq 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n ok \n"
tacmatch test33.dat temp33.dat
if [ $? -ne 0 ] ; then printf "Failed!\n" ; exit 1 ; fi
printf "\n passed. \n\n"




printf "\n===================================================================\n"
printf "   All passed! \n"
printf "===================================================================\n"
exit 0

